//$Id: Alarm32khz16C.nc 788 2006-05-04 19:47:54Z cory $

/* "Copyright (c) 2000-2003 The Regents of the University of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement
 * is hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY
 * OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 */

/** 
 * The TinyOS Timer interfaces are discussed in TEP 102.
 * Alarm32khzC is the alarm for async 32khz alarms.
 * Use Alarm32khz16C for 16bit alarms to prevent the overhead of
 * 32-bit alarms when they are not necessary.
 *
 * @author Cory Sharp, Moteiv Corporation <info@moteiv.com>
 */
generic configuration Alarm32khz16C()
{
  provides interface StdControl as Init;
  provides interface Alarm<T32khz,uint16_t> as Alarm32khz16;
}
implementation
{
  components new MSP430Timer32khzC() as MSP430Timer
           , new MSP430AlarmC(T32khz) as MSP430Alarm
	   , Counter32khzC as Counter
           ;

  Init = MSP430Alarm;

  Alarm32khz16 = MSP430Alarm;

  MSP430Alarm.MSP430Timer -> MSP430Timer;
  MSP430Alarm.MSP430TimerControl -> MSP430Timer;
  MSP430Alarm.MSP430Compare -> MSP430Timer;
}

