//$Id: HPLDMAControl.nc 895 2006-08-02 02:09:54Z polastre $
/* "Copyright (c) 2000-2003 The Regents of the University of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement
 * is hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY
 * OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 */

#include "MSP430DMA.h"

/**
 * Interface for low level access to controlling the DMA module (not channel).
 * Users should access the DMA through the HAL interfaces provided by
 * MSP430DMAC.
 * 
 * @author Ben Greenstein <ben@cs.ucla.edu>
 */
interface HPLDMAControl {

  async command void setOnFetch();
  async command void clearOnFetch();
  async command void setRoundRobin();
  async command void clearRoundRobin();
  async command void setENNMI();
  async command void clearENNMI();
  async command void setState(dma_state_t s);
  async command dma_state_t getState();
  async command void reset();
}
