/*									tab:4
 * "Copyright (c) 2002 and The Regents of the University 
 * of California.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Authors:   Kamin Whitehouse, Joe Polastre, Vladimir Bychkovsky
 *
 */

interface RadioCoordinator
{
  /**
   * This event indicates that the start symbol has been detected 
   * and its offset
   */
  async event void startSymbol(uint8_t bitsPerBlock, uint8_t offset, TOS_MsgPtr msgBuff);

  /**
   * This event indicates that another byte of the current packet has been rxd
   */
  async event void byte(TOS_MsgPtr msg, uint8_t byteCount);

  /**
   * Signals the start of processing of a new block by the radio. This
   * event is signaled regardless of the state of the radio.  This
   * function is currently used to aid radio-based time synchronization.
   */
  async event void blockTimer();
}

