/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.impl;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.event.ClickEvent;
import samples.preview_new_graphdraw.event.ClickListener;
import samples.preview_new_graphdraw.impl.GraphLayoutPanel;

public class GraphLayoutPanelMouseListener
extends MouseAdapter {
    protected final GraphLayoutPanel panel;
    public static double VERTEX_CLICK_THRESHOLD = 400.0;
    public static double EDGE_CLICK_THRESHOLD = 100.0;
    public static double VERTEX_BIAS = 2.0;

    public GraphLayoutPanelMouseListener(GraphLayoutPanel panel) {
        this.panel = panel;
    }

    protected void fireVertexEvent(Vertex v, double dist_to_closest_vertex, MouseEvent e) {
        ClickEvent vce = new ClickEvent(this, v, dist_to_closest_vertex, e);
        Iterator iter = this.panel.listeners.iterator();
        while (iter.hasNext()) {
            ClickListener cl = (ClickListener)iter.next();
            cl.vertexClicked(vce);
        }
    }

    protected void fireEdgeEvent(Edge e, double dist_to_closest_edge, MouseEvent me) {
        ClickEvent ece = new ClickEvent(this, e, dist_to_closest_edge, me);
        Iterator iter = this.panel.listeners.iterator();
        while (iter.hasNext()) {
            ClickListener cl = (ClickListener)iter.next();
            cl.edgeClicked(ece);
        }
    }

    public void mouseClicked(MouseEvent e) {
        Edge closestEdge;
        Vertex closestVertex;
        if (this.panel.listeners == null) {
            return;
        }
        if (this.panel.clickPolicy == GraphLayoutPanel.NO_EVENT_POLICY) {
            return;
        }
        ClickPolicy policy = this.panel.clickPolicy;
        EmittedLayout layout = this.panel.getGraphLayout();
        VisVertex closeVisVertex = null;
        double dist_to_closest_vertex = Double.POSITIVE_INFINITY;
        VisEdge closestVisEdge = null;
        double dist_to_closest_edge = Double.POSITIVE_INFINITY;
        if (policy.shouldCheckVertexDistance() && (closestVertex = layout.getNearestVertex(e.getX(), e.getY())) != null) {
            closeVisVertex = layout.getVisVertex(closestVertex);
            dist_to_closest_vertex = closeVisVertex.getSquareDistance(e.getX(), e.getY());
        }
        if (policy.shouldCheckEdgeDistance() && (closestEdge = layout.getNearestEdge(e.getX(), e.getY())) != null) {
            closestVisEdge = layout.getVisEdge(closestEdge);
            dist_to_closest_edge = closestVisEdge.getSquareDistance(e.getX(), e.getY());
        }
        policy.fireEvents(this, e, closestVisEdge, dist_to_closest_edge, closeVisVertex, dist_to_closest_vertex);
        e.consume();
    }

    public static final class BothEdgeAndVertexPolicy
    implements ClickPolicy {
        public String toString() {
            return "both-edge-and-vertex-policy";
        }

        public boolean shouldCheckVertexDistance() {
            return true;
        }

        public boolean shouldCheckEdgeDistance() {
            return true;
        }

        public void fireEvents(GraphLayoutPanelMouseListener gmpl, MouseEvent me, VisEdge ve, double edgeDist, VisVertex vv, double vertexDistance) {
            if (vertexDistance < VERTEX_CLICK_THRESHOLD) {
                gmpl.fireVertexEvent(vv.getVertex(), vertexDistance, me);
            }
            if (edgeDist < EDGE_CLICK_THRESHOLD) {
                gmpl.fireEdgeEvent(ve.getEdge(), edgeDist, me);
            }
        }
    }

    public static final class EdgeAndVertexPolicy
    implements ClickPolicy {
        public String toString() {
            return "edge-and-vertex-policy";
        }

        public boolean shouldCheckVertexDistance() {
            return true;
        }

        public boolean shouldCheckEdgeDistance() {
            return true;
        }

        public void fireEvents(GraphLayoutPanelMouseListener gmpl, MouseEvent me, VisEdge ve, double edgeDist, VisVertex vv, double vertexDistance) {
            if (vertexDistance < VERTEX_CLICK_THRESHOLD) {
                gmpl.fireVertexEvent(vv.getVertex(), vertexDistance, me);
            } else if (edgeDist < EDGE_CLICK_THRESHOLD) {
                gmpl.fireEdgeEvent(ve.getEdge(), edgeDist, me);
            }
        }
    }

    public static class EdgeEventPolicy
    implements ClickPolicy {
        public String toString() {
            return "edge-event-policy";
        }

        public boolean shouldCheckVertexDistance() {
            return false;
        }

        public boolean shouldCheckEdgeDistance() {
            return true;
        }

        public void fireEvents(GraphLayoutPanelMouseListener gmpl, MouseEvent me, VisEdge ve, double edgeDist, VisVertex vv, double vertexDistance) {
            if (edgeDist < EDGE_CLICK_THRESHOLD) {
                gmpl.fireEdgeEvent(ve.getEdge(), edgeDist, me);
            }
        }
    }

    public static class VertexEventPolicy
    implements ClickPolicy {
        public String toString() {
            return "vertex-event-policy";
        }

        public boolean shouldCheckVertexDistance() {
            return true;
        }

        public boolean shouldCheckEdgeDistance() {
            return false;
        }

        public void fireEvents(GraphLayoutPanelMouseListener gmpl, MouseEvent me, VisEdge ve, double edgeDist, VisVertex vv, double vertexDistance) {
            if (vertexDistance < VERTEX_CLICK_THRESHOLD) {
                gmpl.fireVertexEvent(vv.getVertex(), vertexDistance, me);
            }
        }
    }

    public static class NoEventPolicy
    implements ClickPolicy {
        public String toString() {
            return "no-event-policy";
        }

        public boolean shouldCheckVertexDistance() {
            return false;
        }

        public boolean shouldCheckEdgeDistance() {
            return false;
        }

        public void fireEvents(GraphLayoutPanelMouseListener gmpl, MouseEvent me, VisEdge ve, double edgeDist, VisVertex vv, double vertexDistance) {
        }
    }

    static interface ClickPolicy {
        public boolean shouldCheckVertexDistance();

        public boolean shouldCheckEdgeDistance();

        public void fireEvents(GraphLayoutPanelMouseListener var1, MouseEvent var2, VisEdge var3, double var4, VisVertex var6, double var7);
    }
}

