/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphMouseListener;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GraphZoomScrollPaneDemo {
    Graph graph = new DirectedSparseGraph();
    VisualizationViewer vv;

    public GraphZoomScrollPaneDemo() {
        Vertex[] v = this.createVertices(10);
        this.createEdges(v);
        ImageIcon sandstoneIcon = null;
        String imageLocation = "/samples/images/Sandstone.jpg";
        try {
            sandstoneIcon = new ImageIcon(this.getClass().getResource(imageLocation));
        }
        catch (Exception ex) {
            System.err.println("Can't load \"" + imageLocation + "\"");
        }
        final ImageIcon icon = sandstoneIcon;
        PluggableRenderer pr = new PluggableRenderer();
        this.vv = new VisualizationViewer(new FRLayout(this.graph), (Renderer)pr);
        this.vv.setPickSupport(new ShapePickSupport());
        pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
        if (icon != null) {
            this.vv.addPreRenderPaintable(new VisualizationViewer.Paintable(){

                public void paint(Graphics g) {
                    Dimension d = GraphZoomScrollPaneDemo.this.vv.getSize();
                    g.drawImage(icon.getImage(), 0, 0, d.width, d.height, GraphZoomScrollPaneDemo.this.vv);
                }

                public boolean useTransform() {
                    return false;
                }
            });
        }
        this.vv.addPostRenderPaintable(new VisualizationViewer.Paintable(){
            int x;
            int y;
            Font font;
            FontMetrics metrics;
            int swidth;
            int sheight;
            String str = "GraphZoomScrollPane Demo";

            public void paint(Graphics g) {
                Dimension d = GraphZoomScrollPaneDemo.this.vv.getSize();
                if (this.font == null) {
                    this.font = new Font(g.getFont().getName(), 1, 30);
                    this.metrics = g.getFontMetrics(this.font);
                    this.swidth = this.metrics.stringWidth(this.str);
                    this.sheight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
                    this.x = (d.width - this.swidth) / 2;
                    this.y = (int)((double)d.height - (double)this.sheight * 1.5);
                }
                g.setFont(this.font);
                Color oldColor = g.getColor();
                g.setColor(Color.lightGray);
                g.drawString(this.str, this.x, this.y);
                g.setColor(oldColor);
            }

            public boolean useTransform() {
                return false;
            }
        });
        this.vv.addGraphMouseListener(new TestGraphMouseListener());
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        frame.setDefaultCloseOperation(3);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(GraphZoomScrollPaneDemo.this.vv, 1.1f, GraphZoomScrollPaneDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(GraphZoomScrollPaneDemo.this.vv, 0.9f, GraphZoomScrollPaneDemo.this.vv.getCenter());
            }
        });
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        content.add((Component)controls, "South");
        frame.pack();
        frame.setVisible(true);
    }

    private Vertex[] createVertices(int count) {
        Vertex[] v = new Vertex[count];
        for (int i = 0; i < count; ++i) {
            v[i] = this.graph.addVertex(new DirectedSparseVertex());
        }
        return v;
    }

    void createEdges(Vertex[] v) {
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[3]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[4]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[3], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[1], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[1], v[4]));
        this.graph.addEdge(new DirectedSparseEdge(v[8], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[3], v[8]));
        this.graph.addEdge(new DirectedSparseEdge(v[6], v[7]));
        this.graph.addEdge(new DirectedSparseEdge(v[7], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[9]));
        this.graph.addEdge(new DirectedSparseEdge(v[9], v[8]));
        this.graph.addEdge(new DirectedSparseEdge(v[7], v[6]));
        this.graph.addEdge(new DirectedSparseEdge(v[6], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[5], v[4]));
    }

    public static void main(String[] args) {
        new GraphZoomScrollPaneDemo();
    }

    static class TestGraphMouseListener
    implements GraphMouseListener {
        TestGraphMouseListener() {
        }

        public void graphClicked(Vertex v, MouseEvent me) {
        }

        public void graphPressed(Vertex v, MouseEvent me) {
        }

        public void graphReleased(Vertex v, MouseEvent me) {
        }
    }
}

