/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class HyperbolicMagnificationGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseWheelListener {
    protected final float floor = 0.5f;
    protected final float ceiling = 0.9f;
    protected float delta = 0.02f;

    public HyperbolicMagnificationGraphMousePlugin() {
        this(2);
    }

    public HyperbolicMagnificationGraphMousePlugin(int modifiers) {
        super(modifiers);
    }

    public boolean checkModifiers(MouseEvent e) {
        return (e.getModifiers() & this.modifiers) != 0;
    }

    private void changeMagnification(MutableTransformer transformer, float delta) {
        if (transformer instanceof HyperbolicTransformer) {
            HyperbolicTransformer ht = (HyperbolicTransformer)transformer;
            float magnification = ht.getMagnification() + delta;
            magnification = Math.max(0.5f, magnification);
            magnification = Math.min(magnification, 0.9f);
            ht.setMagnification(magnification);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = this.checkModifiers(e);
        float delta = this.delta;
        if (accepted) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            MutableTransformer modelTransformer = vv.getLayoutTransformer();
            MutableTransformer viewTransformer = vv.getViewTransformer();
            int amount = e.getWheelRotation();
            if (amount < 0) {
                delta = -delta;
            }
            this.changeMagnification(modelTransformer, delta);
            this.changeMagnification(viewTransformer, delta);
            vv.repaint();
            e.consume();
        }
    }
}

