/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.SimpleDirectedSparseVertex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DirectedSparseVertex
extends SimpleDirectedSparseVertex {
    public Set getInEdges() {
        Collection inEdgeSets = this.getPredsToInEdges().values();
        HashSet inEdges = new HashSet();
        Iterator i_iter = inEdgeSets.iterator();
        while (i_iter.hasNext()) {
            inEdges.addAll((Set)i_iter.next());
        }
        return Collections.unmodifiableSet(inEdges);
    }

    public Set getOutEdges() {
        Collection outEdgeSets = this.getSuccsToOutEdges().values();
        HashSet outEdges = new HashSet();
        Iterator o_iter = outEdgeSets.iterator();
        while (o_iter.hasNext()) {
            outEdges.addAll((Set)o_iter.next());
        }
        return Collections.unmodifiableSet(outEdges);
    }

    public Edge findEdge(Vertex v) {
        Set outEdges = (Set)this.getSuccsToOutEdges().get(v);
        if (outEdges == null) {
            return null;
        }
        return (Edge)outEdges.iterator().next();
    }

    public Set findEdgeSet(Vertex v) {
        HashSet edgeSet = new HashSet();
        Set edges = (Set)this.getSuccsToOutEdges().get(v);
        if (edges != null) {
            edgeSet.addAll(edges);
        }
        return Collections.unmodifiableSet(edgeSet);
    }

    protected Collection getEdges_internal() {
        HashSet edges = new HashSet();
        Collection inEdgeSets = this.getPredsToInEdges().values();
        Collection outEdgeSets = this.getSuccsToOutEdges().values();
        Iterator e_iter = inEdgeSets.iterator();
        while (e_iter.hasNext()) {
            edges.addAll((Set)e_iter.next());
        }
        e_iter = outEdgeSets.iterator();
        while (e_iter.hasNext()) {
            edges.addAll((Set)e_iter.next());
        }
        return edges;
    }

    protected void addNeighbor_internal(Edge e, Vertex v) {
        if (!(e instanceof DirectedEdge)) {
            throw new IllegalArgumentException("This vertex implementation only accepts directed edges");
        }
        DirectedEdge de = (DirectedEdge)e;
        boolean added = false;
        if (this == de.getSource()) {
            Map stoe = this.getSuccsToOutEdges();
            HashSet<DirectedEdge> outEdges = (HashSet<DirectedEdge>)stoe.get(v);
            if (outEdges == null) {
                outEdges = new HashSet<DirectedEdge>();
                stoe.put(v, outEdges);
            }
            outEdges.add(de);
            added = true;
        }
        if (this == de.getDest()) {
            Map ptie = this.getPredsToInEdges();
            HashSet<DirectedEdge> inEdges = (HashSet<DirectedEdge>)ptie.get(v);
            if (inEdges == null) {
                inEdges = new HashSet<DirectedEdge>();
                ptie.put(v, inEdges);
            }
            inEdges.add(de);
            added = true;
        }
        if (!added) {
            throw new IllegalArgumentException("Internal error: this vertex is not incident to " + e);
        }
    }

    protected void removeNeighbor_internal(Edge e, Vertex v) {
        boolean predecessor = false;
        boolean successor = false;
        Map ptie = this.getPredsToInEdges();
        Set inEdges = (Set)ptie.get(v);
        Map stoe = this.getSuccsToOutEdges();
        Set outEdges = (Set)stoe.get(v);
        DirectedEdge de = (DirectedEdge)e;
        if (de.getSource() == v && inEdges != null) {
            predecessor = inEdges.remove(e);
            if (inEdges.isEmpty()) {
                ptie.remove(v);
            }
        }
        if (de.getDest() == v && outEdges != null) {
            successor = outEdges.remove(e);
            if (outEdges.isEmpty()) {
                stoe.remove(v);
            }
        }
        if (!predecessor && !successor && this != v) {
            throw new FatalException("Internal error in data structure for vertex " + this);
        }
    }
}

