###############################################################
#  This program is for processing the results generated by
#  tecla_tool.
#  For test case generation
###############################################################
from __future__ import print_function
from collections import defaultdict
import re
import os
import sys
import argparse

###############################################################
# main function
###############################################################
# command line parser
parser = argparse.ArgumentParser()
parser.add_argument("-d", "--directory",
                    help = "process all output files in the direcoty")
parser.add_argument("-e", "--extension",
                    help = "log filename extension")

args = parser.parse_args()

PatOutput =dict()
PatiOutput=dict()

class Result():
	id=''
	safe=1
	p=0
	k=0
	pat=0.0
	ptester=0.0
        def interprateResult(self):
                if self.safe == 1:
                        return 'Yes'
                else:
                        return 'No'
                
	def __init__(self, id):
		self.id = id
                # self.safe = safe
                # self.p = p
                # self.p = p
                # self.pat = ptester
        def write(self):
                print("{},{},{},{},{}".format(self.id, self.interprateResult(), self.k, self.pat, self.ptester))
                
        def writeLess(self):
                print("{},{},{},{}".format(self.id, self.interprateResult(), self.k, self.pat))   

def processRes(line):
	if 'bug' in line:
		return 0
	elif 'converged' in line:
		m = re.search('\d+', line)
		k = int(m.group(0))
		return 1, k
	else:
		return 0, 0

def processTime(line):
        if line.startswith('Time elapsed:'):
		m = re.search('\d*\.\d+|\d+', line)
		time = float(m.group(0))
		# print('time:{}'.format(time))
                return time
        return 0.0

def processPatLogFile(filename, id):
	with open(filename) as ins:
		last=""
		second=""
		for line in ins:
			second=last
			last=line
		# print(filename)
		r, k = processRes(second)
		t = processTime(last)
                PatOutput[id].safe=r
                PatOutput[id].k=k
                PatOutput[id].pat=t

def processPtesterFile(filename, id):
	with open(filename) as ins:
		last=""
		for line in ins:
			last=line
		t = processTime(last)
                PatOutput[id].ptester += t

def processPatiFile(filename,id):
	with open(filename) as ins:
		last=""
		second=""
		for line in ins:
			second=last
			last=line
		# print(filename)
		r, k = processRes(second)
		t = processTime(last)
                PatiOutput[id].safe=r
                PatiOutput[id].k=k
                PatiOutput[id].pat=t

		
def processResults(directory, extension):
    for root, dirs, files in os.walk(directory):
            for file in files:
                    if file.endswith(extension):
                            f = os.path.join(root, file)
		            id = os.path.basename(os.path.dirname(f))
		            # print('DIR:', id)
                            if 'pati' in file:
                                    if id not in PatiOutput:
                                            PatiOutput[id]=Result(id)
                                    processPatiFile(f,id)
                            else:                                   
                                    if id not in PatOutput:
                                            PatOutput[id]=Result(id)
                                            
                                    if 'pat' in file:
		                            processPatLogFile(f,id)
                                    elif 'ptester' in file:
                                            processPtesterFile(f,id)
        
def printPatInOrder(output):
        filename='pat_ptester.csv'
        with open(filename, 'w+') as out:
                out.write('ID/Program,Safe,k_max,PAT,PTester')
                out.write("\n")
                for k in sorted(output.iterkeys()):
                        res=output[k]
                        out.write("{},{},{},{},{}".format(res.id, res.interprateResult(), res.k, res.pat, res.ptester))
                        out.write("\n")

def printPatiInOrder(output):
        filename='pati.csv'
        with open(filename, 'w+') as out:
                out.write('ID/Program,Safe,k_max,PAT\n')
                for k in sorted(output.iterkeys()):
                        res=output[k]
                        out.write("{},{},{},{}\n".format(res.id, res.interprateResult(), res.k, res.pat))
       
# main function
def main():
    try:
        if args.directory:
                output = processResults(args.directory, args.extension)
        print('PAT and PTester results:')
        printPatInOrder(PatOutput)
        print('PAT+I results:')
        printPatiInOrder(PatiOutput)
        
    except ValueError, e:
        print(str(e))

if __name__ == "__main__":
    main()
