/*
to correctly model the cv_broadcast(COND) statement "b1_COND := 1;" must be manually changed to "b1_COND$ := 1;" in the abstract BP
*/

#ifdef SATABS
#define assume(e) __CPROVER_assume(e)
#define atomic(e,f) __CPROVER_atomic_begin(),e,f,__CPROVER_atomic_end()
#define acquire(m) atomic(assume(!m),m = !m)
#define release(m) atomic(assume(m),m = !m)
#endif

#define cv_wait(c,m){ \
  c = 0; \
  release(m); \
  assume(c); \
  acquire(m); }

#ifdef SATABS
#define cv_broadcast(c) __CPROVER_passive_broadcast: c = 1 //set passive waiting flags (requires a new keywork!)
#else
#define cv_broadcast(c) c = 1 //overapproximates semantics (for threader)
#endif

#define LOCKED 1

#define mutex_enter(m) acquire(m);assert(m==LOCKED); //acquire lock and ensure no other thread unlocked it
#define mutex_exit(m) release(m)
#define boolean_t _Bool
#define ASSERT(e) assert(e)
#define MUTEX_HELD(e) (e==LOCKED)
#define B_TRUE 1
#define B_FALSE 0

volatile _Bool MTX = !LOCKED;
#ifdef SATABS
_Thread_local _Bool COND = 0; //local
#else
_Bool COND = 0; //shared
#endif

_Bool LOADED = 0;
_Bool LOADING = 0;

inline boolean_t space_map_contains(){
	ASSERT(MUTEX_HELD(MTX)); }

inline void space_map_walk(){
	ASSERT(MUTEX_HELD(MTX)); }

inline void space_map_load_wait(){
	ASSERT(MUTEX_HELD(MTX));
	while (LOADING) {
		ASSERT(!LOADED);
		cv_wait(COND, MTX);
		ASSERT(COND); }
      	mutex_enter(MTX); }

inline int space_map_load(){
	ASSERT(MUTEX_HELD(MTX));
	ASSERT(!LOADED);
	ASSERT(!LOADING);
	LOADING = B_TRUE;
	mutex_exit(MTX);
	mutex_enter(MTX);
	for (;nondet();) {
		mutex_exit(MTX);
		mutex_enter(MTX);
		if (nondet())
			break; }
	if (nondet())
		LOADED = B_TRUE;
	LOADING = B_FALSE;
	cv_broadcast(COND); }

inline void space_map_unload(){
	ASSERT(MUTEX_HELD(MTX));
	LOADED = B_FALSE;
	ASSERT(MUTEX_HELD(MTX)); }

inline int space_map_alloc(){
	if (nondet())
		ASSERT(MUTEX_HELD(MTX));
	return nondet(); }

inline void space_map_sync(){
	ASSERT(MUTEX_HELD(MTX));
	if (nondet())
		return;
	while (nondet()) {
		while (nondet()) {
			if (nondet()) {
				mutex_exit(MTX);
				mutex_enter(MTX); }}}
	if (nondet()) {
		mutex_exit(MTX);
		mutex_enter(MTX); }}

inline void space_map_ref_generate_map(){
	ASSERT(MUTEX_HELD(MTX)); }

void thr1(){
	mutex_enter(MTX);
	switch(nondet()){
		case 1: space_map_contains(); break;
		case 2: space_map_walk(); break;
		case 3: if(LOADING)
				space_map_load_wait();
			else if(!LOADED)
				space_map_load();
			else
				space_map_unload(); break;
			break;
		case 6: space_map_alloc(); break;
		case 7: space_map_sync(); break;
		case 8: space_map_ref_generate_map(); break; }
	ASSERT(MUTEX_HELD(MTX));
	mutex_exit(MTX); }

#ifdef SATABS
int main(){
	while(1) __CPROVER_ASYNC_01: thr1(); }
#endif

