/*
to correctly model the cv_broadcast(COND) statement "b1_COND := 1;" must be manually changed to "b1_COND$ := 1;" in the abstract BP
*/

#ifdef SATABS
#define assume(e) __CPROVER_assume(e)
#define atomic(e,f) __CPROVER_atomic_begin(),e,f,__CPROVER_atomic_end()
#define acquire(m) atomic(assume(!m),m = !m)
#define release(m) atomic(assume(m),m = !m)
#endif

#define cv_wait(c,m){ \
  c = 0; \
  release(m); \
  assume(c); \
  acquire(m); }

#ifdef SATABS
#define cv_broadcast(c) __CPROVER_passive_broadcast: c = 1 //set passive waiting flags (requires a new keywork!)
#else
#define cv_broadcast(c) c = 1 //overapproximates semantics (for threader)
#endif

#define LOCKED 1

#define mutex_enter(m) acquire(m);assert(m==LOCKED); //acquire lock and ensure no other thread unlocked it
#define mutex_exit(m) release(m)

#define PSWITCH_EVENT_RELEASED 1
#define PENVSYS_EVENT_NORMAL 2
#define POWER_EVENT_RECVDICT 3

#define KASSERT(e) assert(e)
#define is_locked(m) (m==LOCKED)

volatile _Bool MTX = !LOCKED;
#ifdef SATABS
_Thread_local _Bool COND = 0; //local
#else
_Bool COND = 0; //shared
#endif

inline int sysmon_queue_power_event(){
	KASSERT(is_locked(MTX));
	if (nondet())
		return 0;
	return 1; }

inline int sysmon_get_power_event(){
	KASSERT(is_locked(MTX));
	if (nondet())	
		return 0;
	return 1; }

inline int sysmon_power_daemon_task(){
	if (nondet()) return nondet();
	mutex_enter(MTX);
	switch (nondet()) {
	case PSWITCH_EVENT_RELEASED:
		KASSERT(is_locked(MTX));
		if (nondet()) {
			mutex_exit(MTX);
			goto out;}
		break;
	case PENVSYS_EVENT_NORMAL:
		KASSERT(is_locked(MTX));
		if (nondet()) {
			mutex_exit(MTX);
			goto out;}
		break;
	default:
		mutex_exit(MTX);
		goto out;}
	sysmon_queue_power_event();
	if (nondet()) {
		mutex_exit(MTX);
		goto out;} 
	else {
		cv_broadcast(COND);
		mutex_exit(MTX);}
	out:
	return nondet(); }

inline int sysmonopen_power(){
	mutex_enter(MTX);
	if (nondet())
		KASSERT(is_locked(MTX));
	mutex_exit(MTX); }

inline int sysmonclose_power(){
	mutex_enter(MTX);
	KASSERT(is_locked(MTX));
	mutex_exit(MTX); }

inline int sysmonread_power(){
	if (nondet()){
		mutex_enter(MTX);
		for (;;) {
			if (sysmon_get_power_event()) {
				break;}
			if (nondet()) {
				break;}
			cv_wait(COND,MTX);
      assert(COND); }
		mutex_exit(MTX); }}

inline int sysmonpoll_power(){
	if(nondet()){
		mutex_enter(MTX);
		mutex_exit(MTX); }}

inline void filt_sysmon_power_rdetach(){
	mutex_enter(MTX);
	mutex_exit(MTX); }

inline int filt_sysmon_power_read(){
	mutex_enter(MTX);
	mutex_exit(MTX); }

inline int sysmonkqfilter_power(){
	mutex_enter(MTX);
	mutex_exit(MTX); }

inline int sysmonioctl_power(){
	switch (nondet()) {
	case POWER_EVENT_RECVDICT:
		mutex_enter(MTX);
		if (nondet()) {
			mutex_exit(MTX);
			break;}
		mutex_exit(MTX);
		mutex_enter(MTX);
		mutex_exit(MTX);
		break; }}

void thr1(){
  while(1)
    switch(nondet()){
    case 0: sysmon_power_daemon_task(); break;
    case 1: sysmonopen_power(); break;
    case 2: sysmonclose_power(); break;
    case 3: sysmonread_power(); break;
    case 4: sysmonpoll_power(); break;
    case 5: filt_sysmon_power_rdetach(); break;
    case 6: filt_sysmon_power_read(); break;
    case 7: sysmonkqfilter_power(); break;
    case 8: sysmonioctl_power(); break; }}

#ifdef SATABS
int main(){
  while(1) __CPROVER_ASYNC_01: thr1(); }
#endif

