/*
to correctly model the cv_broadcast(COND) statement "b1_COND := 1;" must be manually changed to "b1_COND$ := 1;" in the abstract BP
*/

#ifdef SATABS
#define assume(e) __CPROVER_assume(e)
#define atomic(e,f) __CPROVER_atomic_begin(),e,f,__CPROVER_atomic_end()
#define acquire(m) atomic(assume(!m),m = !m)
#define release(m) atomic(assume(m),m = !m)
#endif

#define cv_wait(c,m){ \
  c = 0; \
  release(m); \
  assume(c); \
  acquire(m); }

#ifdef SATABS
#define cv_broadcast(c) __CPROVER_passive_broadcast: c=1 //__CPROVER_passive(c) = 1; //set passive waiting flags (requires a new keywork!)
#else
#define cv_broadcast(c) c = 1 //overapproximates semantics (for threader)
#endif

#define LOCKED 1

#define mtx_lock(m) acquire(m);assert(m==LOCKED); //acquire lock and ensure no other thread unlocked it
#define mtx_unlock(m) release(m)

volatile _Bool MTX = !LOCKED;
#ifdef SATABS
_Thread_local _Bool COND = 0;
#else
_Bool COND = 0; //shared
#endif

volatile int refctr = 0;

inline static void put_client(int client){
	mtx_lock(MTX);
	--refctr;
	if (refctr == 0) {
		cv_broadcast(COND); }
	mtx_unlock(MTX); }

inline void rdma_addr_unregister_client(int client){
	put_client(client);
	mtx_lock(MTX);
	if (refctr) {
		cv_wait(COND,MTX); }
	mtx_unlock(MTX); }

inline static void queue_req(/*struct addr_req *req*/){
	mtx_lock(MTX);
	mtx_unlock(MTX); }

inline static void process_req(/*void *ctx, int pending*/){
	mtx_lock(MTX);
	mtx_unlock(MTX); }

inline int rdma_resolve_ip(/*struct rdma_addr_client *client,struct sockaddr *src_addr, struct sockaddr *dst_addr,struct rdma_dev_addr *addr, int timeout_ms,void (*callback)(int status, struct sockaddr *src_addr,struct rdma_dev_addr *addr, void *context),void *context*/){
	mtx_lock(MTX);
	refctr++;
	mtx_unlock(MTX);
	if(nondet()){
		mtx_lock(MTX);
		refctr--;
		mtx_unlock(MTX); }}

inline void rdma_addr_cancel(/*struct rdma_dev_addr *addr*/){
	mtx_lock(MTX);
	mtx_unlock(MTX); }

void thr1(){
  while(1)
    switch(nondet()){
    case 0: rdma_addr_unregister_client(nondet()); break;
    case 1: queue_req(); break;
    case 2: process_req(); break;
    case 2: rdma_resolve_ip(); break;
    case 4: rdma_addr_cancel(); break; 
  }
}

#ifdef SATABS
int main(){
  while(1) __CPROVER_ASYNC_01: thr1(); }
#endif
