/*
to correctly model the cv_broadcast(COND) statement "b1_COND := 1;" must be manually changed to "b1_COND$ := 1;" in the abstract BP
*/

#ifdef SATABS
#define assume(e) __CPROVER_assume(e)
#define atomic(e,f) __CPROVER_atomic_begin(),e,f,__CPROVER_atomic_end()
#define acquire(m) atomic(assume(!m),m = !m)
#define release(m) atomic(assume(m),m = !m)
#endif

#define cv_wait(c,m){ \
  c = 0; \
  release(m); \
  assume(c); \
  acquire(m); }

#ifdef SATABS
#define cv_broadcast(c) __CPROVER_passive_broadcast: c = 1 //set passive waiting flags (requires a new keywork!)
#else
#define cv_broadcast(c) c = 1 //overapproximates semantics (for threader)
#endif

#define LOCKED 1

#define mtx_lock(m) acquire(m);assert(m==LOCKED); //acquire lock and ensure no other thread unlocked it
#define mtx_unlock(m) release(m)

volatile _Bool MTX = !LOCKED;
#ifdef SATABS
_Thread_local _Bool COND = 0; //local
#else
_Bool COND = 0; //shared
#endif
_Bool buf = 0;

inline static int adb_kbd_receive_packet(){
	mtx_lock(MTX);
	mtx_unlock(MTX);
	cv_broadcast(COND);
	return 0; }
	
inline static void akbd_repeat() {
	mtx_lock(MTX);
	mtx_unlock(MTX); }
	
inline static int akbd_read_char(int wait) {
	mtx_lock(MTX);
	if (!buf && wait){
		cv_wait(COND,MTX);
		assert(COND);}
	if (!buf) {
		mtx_unlock(MTX);
		return (0); 	}
	mtx_unlock(MTX); }
	
inline static void akbd_clear_state(){
	mtx_lock(MTX);
	buf = 0;
	mtx_unlock(MTX); }

void thr1(){
  while(1)
  {
    switch(nondet())
    {
    case 0: adb_kbd_receive_packet(); break;
    case 1: akbd_repeat(); break;
    case 2: akbd_read_char(nondet()); break;
    case 3: akbd_clear_state(); break;
    #ifdef SATABS
    case 4: while(1){
        mtx_lock(MTX);
        buf = !buf;
        mtx_unlock(MTX);
      }
    #else
    case 4: 
        mtx_lock(MTX);
        if(buf) buf = 0; else buf = 1;
        mtx_unlock(MTX);
    #endif    
    }
  }
}

#ifdef SATABS
int main(){
  while(1) __CPROVER_ASYNC_01: thr1(); }
#endif