//Ticket lock with proportional backoff
//Algorithms for Scalable Synchronization on Shared-Memory Multiprocessors
//ACM TOCS
//February 1991

volatile unsigned s = 0; //served
volatile unsigned t = 0; //next ticket

#ifdef SATABS
#define atomic_fetch_and_inc(l,t) \
__CPROVER_atomic_begin(); \
__CPROVER_assume(t != -1); /* pretend "integer-semantics" */ \
l = t; \
t = t + 1; \
__CPROVER_atomic_end();
#else
#define atomic_fetch_and_inc(l,t) \
{ __blockattribute__((atomic)) \
l = t; \
t = t + 1; \
}
#endif

#define pause(e)

#define spin_lock(l,t,s)\
{\
  atomic_fetch_and_inc(l,t); \
  while(1) { \
    pause(l - s); \
    /* consume this many units of time */ \
    /* on most machines, subtraction works correctly despite overflow */ \
    if(s == l) \
      break; \
  }\
}

#define spin_unlock(s)\
{\
  s++;\
}

unsigned c = 0;
void thr1()
{
while(1){
  unsigned l;
  spin_lock(l,t,s);
  c = 1; assert(c == 1); c = 0;
  spin_unlock(s);
  }
}

#ifdef SATABS
void main()
{
  while(nondet()) __CPROVER_ASYNC_01: thr1();
  thr1();
}
#endif
