int count = 0;

#ifdef SATABS
#define assume(e) __CPROVER_assume(e)
#define assert(e) __CPROVER_assert(e,"error")

#define acquire(m) \
{ \
  __CPROVER_atomic_begin(); \
	assume(m==0); \
	m = 1; \
	__CPROVER_atomic_end(); \
}
#define release(m) \
{ \
  __CPROVER_atomic_begin(); \
	assume(m==1); \
	m = 0; \
	__CPROVER_atomic_end(); \
}
#endif

int mutexa = 0;
int mutexb = 0;
inline void my_thread1()
{
  acquire(mutexa);
  count++;
  count--;
  release(mutexa);
  return;
}

inline void my_thread2()
{
  acquire(mutexb);
  count--;
  count++;
  release(mutexb);
  return;
}

void thr1()
{
  while(1)
  {

    acquire(mutexa);
    assert(count >= -1);
    release(mutexa);

    acquire(mutexb);
    assert(count <= 1);
    release(mutexb);

  }
}

void thr2()
{
  if(nondet())
    my_thread1();
  else
    my_thread2();
}

#ifdef SATABS
int main(void)
{
  __CPROVER_ASYNC_01: thr1();
  while(1)
  {
      __CPROVER_ASYNC_02: thr2();
  }
}
#endif

