#ifdef SATABS

#define assume(e) __CPROVER_assume(e)
#define assert(e) __CPROVER_assert(e,"error")

#define acquire(m) \
{ \
  __CPROVER_atomic_begin(); \
	assume(m==0); \
	m = 1; \
	__CPROVER_atomic_end(); \
}
#define release(m) \
{ \
  __CPROVER_atomic_begin(); \
	assume(m==1); \
	m = 0; \
	__CPROVER_atomic_end(); \
}
#endif

#define MONITOR_EQ(x,y,m) \
{ \
  while(1) \
  {\
    acquire(m);\
    assert(g0==g1);\
    release(m);\
  }\
}

int g0 = 0,g1 = 0,x = 0;
_Bool lock = 0;
int mutex = 0;

void thr3()
{

  acquire(mutex);
  if(rand())
  {
    g0=0;
    g1=0;
    lock=0;
  }
  release(mutex);
  
  acquire(mutex);
  if(lock)
  {
    x=1;
    assert(g0==1 && g1==1);
  }
  release(mutex);
}

void thr2()
{
  MONITOR_EQ(g0,g1,mutex);
}

void thr1()
{
  acquire(mutex);
  g0=1,g1=1;
  release(mutex);
  lock=1;

  return 0;
}

#ifdef SATABS
int main() {
  __CPROVER_ASYNC_01: thr1();
  __CPROVER_ASYNC_01: thr2();
  while(1)
  {
    __CPROVER_ASYNC_02: thr3();
  }
}
#endif
