#ifdef SATABS
#define assume(e) __CPROVER_assume(e)
#define assert(e) __CPROVER_assert(e,"error")

#define acquire(m) \
{ \
  __CPROVER_atomic_begin(); \
	assume(m==0); \
	m = 1; \
	__CPROVER_atomic_end(); \
}
#define release(m) \
{ \
  __CPROVER_atomic_begin(); \
	assume(m==1); \
	m = 0; \
	__CPROVER_atomic_end(); \
}
#endif

int nondet();

int a = 1;
int b = 2;
int c = 3;
int temp;

int mutex;


int thr2() {
  
  for(;;){
    acquire(mutex);
    temp = a;
    a = b;
    b = c;
    c = temp;
    release(mutex);
  }

}

void thr1()
{
  while(1)
  {
    acquire(mutex);
    assert(a != b);
    release(mutex);
  }
}

#ifdef SATABS
int main() {
  __CPROVER_ASYNC_01: thr1();
  while(1)
  {
    __CPROVER_ASYNC_02: thr2();
  }
}
#endif

