#ifdef SATABS
#define assume(e) __CPROVER_assume(e)
#define assert(e) __CPROVER_assert(e,"error")

#define acquire(m) \
{ \
  __CPROVER_atomic_begin(); \
	assume(m==0); \
	m = 1; \
	__CPROVER_atomic_end(); \
}
#define release(m) \
{ \
  __CPROVER_atomic_begin(); \
	assume(m==1); \
	m = 0; \
	__CPROVER_atomic_end(); \
}
#endif

int nondet_int();
int mutex;
int res;

typedef int (*FuncType)(int, int);

inline int f1(int a, int b)
{
  return a+b+1;
}

inline int f2(int x, int y)
{
  return x-y+2;
}

int thr2()
{
  FuncType pf;

  if( nondet_int() )
    pf = f1;
  else
    pf = f2;

  acquire(mutex);
  res = pf(4,3);
  release(mutex);
}

void thr1()
{
  while(1)
  {
    assert(res < 10);
  }
}

#ifdef SATABS
int main()
{
  __CPROVER_ASYNC_01: thr1();
  while(1)
  {
    __CPROVER_ASYNC_02: thr2();
  }
}
#endif

