package test.game;

import static org.junit.Assert.assertEquals;
import logging.Logger;

import org.junit.Before;
import org.junit.Test;

import player.PlayerFactory;
import player.PlayerServer;
import scg.Util;
import scg.game.BinaryGame;
import scg.game.LocalPlayerProxy;
import scg.game.BinaryGame.Result;
import scg.game.Game.PlayerStore;
import scg.gen.Config;
import scg.gen.Objective;
import scg.gen.PlayerSpec;
import scg.gen.TBall;

public class CheckTournamentPoints {

    LocalPlayerProxy pp1, pp2;
    BinaryGame game;
    PlayerStore p1, p2;

    @Before
    public void init(){
        PlayerFactory pf = PlayerFactory.create(edu.neu.ccs.demeterf.lib.List.create("--smart"));
        PlayerServer playerServer = new PlayerServer(pf, Logger.text(System.out));
        Config config = new Config("CSP", 60, 0.01, 15, 5, 1, 1, new Objective(), new TBall(1000), 5, 1.0, 2, true, 0.2);

        LocalPlayerProxy pp1 = new LocalPlayerProxy(new PlayerSpec("p1", "", 0), playerServer);
        LocalPlayerProxy pp2 = new LocalPlayerProxy(new PlayerSpec("p2", "", 0), playerServer);

        game = new BinaryGame(config, pp1, pp2);
        p1 = game.getPlayers().get(0);
        p2 = game.getPlayers().get(1);

    }

    @Test
    public void kickedIsEffective1(){

        p1.setAccount(100);
        p1.setKicked(false);

        p2.setAccount(200);
        p2.setKicked(true);

        game.assignPoints(p1, p2);
        Result result = game.getResult();
        int p1Points = result.getPoints("p1");
        int p2Points = result.getPoints("p2");
        assertEquals(p1Points, 3);
        assertEquals(p2Points, 0);

    }

    @Test
    public void kickedIsEffective2(){

        p1.setAccount(100);
        p1.setKicked(false);

        p2.setAccount(50);
        p2.setKicked(true);

        game.assignPoints(p1, p2);
        Result result = game.getResult();
        int p1Points = result.getPoints("p1");
        int p2Points = result.getPoints("p2");
        assertEquals(p1Points, 3);
        assertEquals(p2Points, 0);

    }

    @Test
    public void BothKicked(){

        p1.setAccount(100);
        p1.setKicked(true);

        p2.setAccount(200);
        p2.setKicked(true);

        game.assignPoints(p1, p2);
        Result result = game.getResult();
        int p1Points = result.getPoints("p1");
        int p2Points = result.getPoints("p2");
        assertEquals(p1Points, 1);
        assertEquals(p2Points, 1);
    }

    @Test
    public void BothIn(){

        p1.setAccount(300);
        p1.setKicked(false);

        p2.setAccount(200);
        p2.setKicked(false);

        game.assignPoints(p1, p2);
        Result result = game.getResult();
        int p1Points = result.getPoints("p1");
        int p2Points = result.getPoints("p2");
        assertEquals(p1Points, 3);
        assertEquals(p2Points, 0);
    }

    @Test
    public void BothInSmallDifference(){

        p1.setAccount(300);
        p1.setKicked(false);

        p2.setAccount(300 + Util.DELTA);
        p2.setKicked(false);

        game.assignPoints(p1, p2);
        Result result = game.getResult();
        int p1Points = result.getPoints("p1");
        int p2Points = result.getPoints("p2");
        assertEquals(p1Points, 1);
        assertEquals(p2Points, 1);
    }

    @Test
    public void BothInSmallDifference2(){

        p1.setAccount(300);
        p1.setKicked(false);

        p2.setAccount(300 - Util.DELTA);
        p2.setKicked(false);

        game.assignPoints(p1, p2);
        Result result = game.getResult();
        int p1Points = result.getPoints("p1");
        int p2Points = result.getPoints("p2");
        assertEquals(p1Points, 1);
        assertEquals(p2Points, 1);
    }
}
