package test;

/**  */
public class TestHarness {
    /**  */
    int failures;
    /**  */
    int tests;
    /**  */
    static double DELTA = 0.000001;
    
    /**  */
    public void check(int val, int expect, String msg){ check((long)val, expect, msg); }
    /**  */
    public void check(long val, long expect, String msg){ assertTrue(val == expect, msg); }
    /**  */
    public void check(float val, float expect, String msg){ check((double)val, expect, msg); }
    /**  */
    public void check(double val, double expect, String msg){
        assertTrue(Math.abs(val-expect) < DELTA, msg);    
    }
    
    /**  */
    public void assertTrue(boolean v, String msg){
        tests++;
        if(!v){
            System.err.println(" * Test "+msg+" FAILED");
            failures++;
        }
    }
    /**  */
    public void report(){
        System.err.println(" * Ran "+tests+" Tests, "+failures+" Failures.");
    }
}
