package test;

import scg.gen.*;

public class TestContexts extends TestCheckTrans {
  
    /**  */
    void expectFailure(PlayerContext ctx, PlayerTrans t, String msg){
        try{
            ctx.isLegal(t);
            assertTrue(false, msg);
        }catch(scg.game.GameI.BadTransException a){
            System.out.println(" * Exception: \""+a.getMessage()+"\"");
            assertTrue(true, msg);
        }
    }
    /**  */
    void expectSuccess(PlayerContext ctx, PlayerTrans t, String msg){
        try{
            ctx.isLegal(t);
            assertTrue(true, msg);
        }catch(scg.game.GameI.BadTransException a){
            System.out.println(" * Exception: \""+a.getMessage()+"\"");
            assertTrue(false, msg);
        }
    }
    
    /**  */
    public static void main(String[] args){
        TestCheckTrans test = new TestContexts();
        for(Turn t : badTests)test.expectFailure(t.context, t.trans, t.msg);
        for(Turn t : goodTests)test.expectSuccess(t.context, t.trans, t.msg);
        test.report();
    }
}
