package test;

import edu.neu.ccs.demeterf.lib.List;
import scg.gen.*;
import scg.game.CheckTrans;

public class TestCheckTrans extends TestHarness {
    static Config allCfg = makeCfg(new TBall(4), false);
    static Config secretCfg = makeCfg(new TBall(4), true);

    static Config makeCfg(Predicate p, boolean sec){
        return new Config("CSP", 60, 0.01, 15, 2, 1, 1, new Objective(), p, 5, 1.0, 2, sec, 0.2);
    }
    
    /** Bad context/transaction pairs for each rule */
    static List<Turn> badTests = List.create(
            // Meat of the context   | Resulting   |  What we tested
            // not including the Cfg | Transaction |
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 9 offer[1 all (2) 0.5] ]", "Wrong Player ID in Transaction"),
            
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 reoffer[1 0.4] accept[1] ]", "Reoffer/Accept the same challenge"),        
            
            Turn.make("10 50.0 1 () () () (provided[ 10 v0 v1 v2 (52 {1} v0 v1 v2) 1 9 (2) 0.5 all])", "playertrans[ 10 offer[2 all (2) 0.5] ]", "Solve all Provided"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] ]", "Provide all Accepted"),
            
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 ]", "No proposals"),
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 offer[1 all (3) 0.5] ]", "Not enough oppositions"),
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2) 0.5] offer[1 all (3) 0.5] offer[1 all (4) 0.5]]", "Too many proposals"),
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 offer[2 all (3) 0.5] offer[3 all (4) 0.5] reoffer[1 0.4]]", "Too many proposals"),
            
            Turn.make(secretCfg, "10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2) 0.5] ]", "Secrets percentage:1"),
            Turn.make(secretCfg, "10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2) 0.5] offer[2 all (3) 0.5] ]", "Secrets percentage:2"),
            
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2) -0.5] ]", "Neg Price"),
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2) 1.0001] ]", "Price Too High"),
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 secret (2) 0.5] ]", "Secrets not allowed"),
            
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (-1) 0.5] ]", "Offer bad relation"),
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (256) 0.5] ]", "Offer bad relation"),
            Turn.make("10 50.0 1 (offered[ 1  9 (2) 0.5 all]) () () ()", "playertrans[ 10 offer[1 all (2) 0.5] ]", "Offer existing type"),
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 offer[1 all (2) 0.5] ]", "Offer existing type"),
            
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2 4) 0.5] ]", "Invalid TBall"),
            Turn.make(makeCfg(new SlowPitchOrTBall(4), false), "10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2 4) 0.5] ]", "Invalid SlowPitch"),
            Turn.make(makeCfg(new FastPitchOrSlowPitchOrTBall(4), false), "10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2 -1) 0.5] ]", "Invalid FastPitch"),
            
            Turn.make("10 50.0 1 (offered[ 1  9 (2) 0.5 all]) () () ()", "playertrans[ 10 accept[1] ]", "Accept non-existing"),
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 accept[1] ]", "Accept non-existing"),
            
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (52 {1} v0 v1 v2) 3] ]", "Provide un-accepted"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 secret]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {1} v0 v1 v2) 1] ]", "Provide no secret"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (3 {1} v0 v1 v2) 1] ]", "Provide wrong type"),
            
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 reoffer[1 0.5] ]", "Reoffer non-existing"),
            Turn.make("10 50.0 1 (offered[ 1  9 (2) 0.5 all]) () () ()", "playertrans[ 10 reoffer[1 0.5] ]", "Reoffer non-existing"),
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 reoffer[1 0.49001] ]", "Reoffer not cheap enough"),
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 reoffer[1 0.490001] ]", "Reoffer not cheap enough"),
            
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {1} v1 v3 v2) 1] ]", "Undeclared Vars"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 v3 v4 v5 (2 {1} v0 v1 v2) 1] ]", "Too Many Vars"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()",
                    "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {1} v0 v1 v2) (2 {1} v0 v1 v2) "+
                    "(2 {1} v0 v1 v2) (2 {1} v0 v1 v2) (2 {1} v0 v1 v2)1] ]", "Too Many Clauses"),
                    
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (-1 {1} v0 v1 v2) 1] ]", "Provide Bad Relation"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (256 {1} v0 v1 v2) 1] ]", "Provide Bad Relation"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {0} v0 v1 v2) 1] ]", "Provide Bad Weight"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {-1} v0 v1 v2) 1] ]", "Provide Bad Weight"),
            
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {1} v0 v1) 1] ]", "Provide Small Clause"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 v3 (2 {1} v0 v1 v2 v3) 1] ]", "Provide Big Clause")
            );

    /** Good (positive) tests... fixed versions of the bad ones... Think "not" for each of the messages */
    static List<Turn> goodTests = List.create(
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2) 0.5] ]", "Wrong Player ID in Transaction"),
            
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 reoffer[1 0.4] ]", "Reoffer/Accept the same challenge"),        
            
            Turn.make("10 50.0 1 () () () (provided[ 10 v0 v1 v2 (52 {1} v0 v1 v2) 1 9 (2) 0.5 all])", "playertrans[ 10 offer[2 all (2) 0.5] solve[ [ ] 1 ]]", "Solve all Provided"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[ v0 v1 v2 (2 {1} v0 v1 v2) 1] ]", "Provide all Accepted"),
            
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 reoffer[ 1 0.4 ] offer[2 all (3) 0.5] ]", "Not enough oppositions"),
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2) 0.5] offer[1 all (3) 0.5] ]", "Too many proposals"),
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 offer[2 all (3) 0.5] reoffer[1 0.4]]", "Too many proposals"),
            
            Turn.make(secretCfg, "10 50.0 1 () () () ()", "playertrans[ 10 offer[1 secret (2) 0.5] ]", "Secrets percentage:3"),
            Turn.make(secretCfg, "10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2) 0.5] offer[2 secret (3) 0.5] ]", "Secrets percentage:4"),
            
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2) 0.0] ]", "Neg Price"),
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2) 1.0] ]", "Price Too High"),
            
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (0) 0.5] ]", "Offer bad relation"),
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (255) 0.5] ]", "Offer bad relation"),
            Turn.make("10 50.0 1 (offered[ 1  9 (2) 0.5 all]) () () ()", "playertrans[ 10 offer[1 all (3) 0.5] ]", "Offer existing type"),
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 reoffer[1 0.4] ]", "Offer existing type"),
            
            Turn.make("10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (3) 0.5] ]", "Invalid TBall"),
            Turn.make(makeCfg(new SlowPitchOrTBall(4), false), "10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2 3 7) 0.5] ]", "Invalid SlowPitch"),
            Turn.make(makeCfg(new FastPitchOrSlowPitchOrTBall(4), false), "10 50.0 1 () () () ()", "playertrans[ 10 offer[1 all (2 4 8) 0.5] ]", "Invalid FastPitch"),
            
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 offer[1 all (3) 0.5] accept[1] ]", "Accept non-existing"),
            
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 secret]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {1} v0 v1 v2) [ ] 1] ]", "Provide no secret"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {1} v0 v1 v2) 1] ]", "Provide wrong type"),
            
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 reoffer[1 0.48999] ]", "Reoffer not cheap enough"),
            Turn.make("10 50.0 1 () (offered[ 1 9 (2) 0.5 all]) () ()", "playertrans[ 10 reoffer[1 0.489999] ]", "Reoffer not cheap enough"),
            
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 v3 (2 {1} v1 v3 v2) 1] ]", "Undeclared Vars"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 v3 (2 {1} v0 v1 v2) 1] ]", "Too Many Vars"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()",
                    "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {1} v0 v1 v2) (2 {1} v0 v1 v2) (2 {1} v0 v1 v2) 1] ]", "Too Many Clauses"),
                    
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {1} v0 v1 v2) 1] ]", "Provide Bad Relation"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {1} v0 v1 v2) 1] ]", "Provide Bad Weight"),
            Turn.make("10 50.0 1 () () (accepted[9 1 10 (2) 0.5 all]) ()", "playertrans[ 10 offer[2 all (2) 0.5] provide[v0 v1 v2 (2 {20} v0 v1 v2) 1] ]", "Provide Bad Weight")
    );
    
    /**  */
    void expectFailure(PlayerContext ctx, PlayerTrans t, String msg){
        try{
            CheckTrans.checkTransaction(t, ctx);
            assertTrue(false, msg);
        }catch(java.lang.Error a){
            //System.out.println(" * Assertion: \""+a.getMessage()+"\"");
            assertTrue(true, msg);
        }
    }
    /**  */
    void expectSuccess(PlayerContext ctx, PlayerTrans t, String msg){
        try{
            CheckTrans.checkTransaction(t, ctx);
            assertTrue(true, msg);
        }catch(java.lang.Error a){
            //System.out.println(" * Assertion: \""+a.getMessage()+"\"");
            assertTrue(false, msg);
        }
    }
    
    static class Turn{
        PlayerContext context;
        PlayerTrans trans;
        String msg;
        
        public Turn(PlayerContext ctxt, PlayerTrans t, String m){
            context = ctxt;
            trans = t;
            msg = m;
        }
        public static Turn make(PlayerContext ctxt, PlayerTrans t, String m){ return new Turn(ctxt,t,m); }
        public static Turn make(String endctxt, String t, String m){
            return make(allCfg, endctxt, t, m);
        }
        public static Turn make(Config cfg, String endctxt, String t, String m){
            try{
                return make(
                        PlayerContext.parse("context["+cfg+"\n"+endctxt+"]"),
                        PlayerTrans.parse(t),m);
            }catch(ParseException e){ throw new RuntimeException(e); }
        }
    }
    /**  */
    public static void main(String[] args){
        TestCheckTrans test = new TestCheckTrans();
        for(Turn t : badTests)test.expectFailure(t.context, t.trans, t.msg);
        for(Turn t : goodTests)test.expectSuccess(t.context, t.trans, t.msg);
        test.report();
    }
    
}
