// ** This class was generated with DemFGen (vers:11/17/2009)

package scg.gen;

import scg.Util;
import scg.game.*;
import edu.neu.ccs.demeterf.lib.*;




/** Representation of PlayerContext */
public class PlayerContext{
    protected final Config config;
    protected final PlayerID id;
    protected final double balance;
    protected final int currentRound;
    protected final List<OfferedChallenge> ourOffered;
    protected final List<OfferedChallenge> theirOffered;
    protected final List<AcceptedChallenge> accepted;
    protected final List<ProvidedChallenge> provided;
    protected final List<SolvedChallenge> solved;
    protected final Option<AccountTransactionList> statement;

    /** Construct a(n) PlayerContext Instance */
    public PlayerContext(Config config, PlayerID id, double balance, int currentRound, List<OfferedChallenge> ourOffered, List<OfferedChallenge> theirOffered, List<AcceptedChallenge> accepted, List<ProvidedChallenge> provided, List<SolvedChallenge> solved, Option<AccountTransactionList> statement){
        this.config = config;
        this.id = id;
        this.balance = balance;
        this.currentRound = currentRound;
        this.ourOffered = ourOffered;
        this.theirOffered = theirOffered;
        this.accepted = accepted;
        this.provided = provided;
        this.solved = solved;
        this.statement = statement;
    }
    /** Is the given object Equal to this PlayerContext? */
    public boolean equals(Object o){
        if(!(o instanceof PlayerContext))return false;
        if(o == this)return true;
        PlayerContext oo = (PlayerContext)o;
        return (((Object)config).equals(oo.config))&&(((Object)id).equals(oo.id))&&(((Object)balance).equals(oo.balance))&&(((Object)currentRound).equals(oo.currentRound))&&(((Object)ourOffered).equals(oo.ourOffered))&&(((Object)theirOffered).equals(oo.theirOffered))&&(((Object)accepted).equals(oo.accepted))&&(((Object)provided).equals(oo.provided))&&(((Object)solved).equals(oo.solved))&&(((Object)statement).equals(oo.statement));
    }
    /** Parse an instance of PlayerContext from the given String */
    public static PlayerContext parse(String inpt) throws ParseException{
        return new TheParser(new java.io.StringReader(inpt)).parse_PlayerContext();
    }
    /** Parse an instance of PlayerContext from the given Stream */
    public static PlayerContext parse(java.io.InputStream inpt) throws ParseException{
        return new TheParser(inpt).parse_PlayerContext();
    }
    /** Parse an instance of PlayerContext from the given Reader */
    public static PlayerContext parse(java.io.Reader inpt) throws ParseException{
        return new TheParser(inpt).parse_PlayerContext();
    }

    /** Field Class for PlayerContext.config */
    public static class config extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for PlayerContext.id */
    public static class id extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for PlayerContext.balance */
    public static class balance extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for PlayerContext.currentRound */
    public static class currentRound extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for PlayerContext.ourOffered */
    public static class ourOffered extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for PlayerContext.theirOffered */
    public static class theirOffered extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for PlayerContext.accepted */
    public static class accepted extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for PlayerContext.provided */
    public static class provided extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for PlayerContext.solved */
    public static class solved extends edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for PlayerContext.statement */
    public static class statement extends edu.neu.ccs.demeterf.Fields.any{}

    /** Is this context in an overtime Round? */
    public boolean isOverTime(){
        return config.isOverTime(currentRound);
    }

    /** Return all the Offered Challenges */
    public List<OfferedChallenge> getAllOffered(){
        return ourOffered.append(theirOffered);
    }

    /**
     * Is the give transaction legal for this PlayerContext... i.e., does it
     * break any of the game rules?
     */
    public void isLegal(PlayerTrans trans){
        AgentsAreActiveButNotHyperActive(trans); // Rule 2
        AgentsProposeEnoughSecretChallenges(trans);
        // DontOfferOrAcceptIfOverTime(trans);
        offerNewChallenges(trans); // Rule 3
        provideAllAccepted(trans);// Rule 4
        offerValidProblemTypes(trans);
        provideCorrectProblems(trans);// Rule 4
        solveFromProvided(trans);// Rule 4
        checkReoffersDecrement(trans);// Rule 5
        acceptFromOthers(trans);// Rule 6*
        dontAcceptAndReoffer(trans);// ** New Rule
        reofferFromOthers(trans);// Rule 7
        currentPlayerResponded(trans);
        offerPricesInRange(trans);
        secretChallengesHaveSecrets(trans);
    }

    private void AgentsProposeEnoughSecretChallenges(PlayerTrans trans){
        int numOffers = trans.getOfferTrans().length();
        int secretOffers = 0;
        for (OfferTrans ot : trans.getOfferTrans()) {
            if (ot.kind.isSecret()) {
                secretOffers++;
            }
        }
        int requiredSecretOffers = (int) (config.getSecretRatio() * numOffers + (1.0 - config.getSecretRatio()));
        if (config.getHasSecrets() && secretOffers < requiredSecretOffers) {
            throw new GameI.BadTransException("Agent didn't offer enough secret challenges");
        }
        if (!config.getHasSecrets() && secretOffers > 0) {
            throw new GameI.BadTransException("Agent should not offer any secret challenges");
        }
    }

    private void AgentsAreActiveButNotHyperActive(PlayerTrans trans){
        if (!isOverTime()) {
            int numProposals = trans.getOfferTrans().length() + trans.getReofferTrans().length();
            int numOppositions = trans.getAcceptTrans().length() + trans.getReofferTrans().length();
            int maxProposals = config.getMaxProposals();
            int minProposals = config.getMinProposals();
            int minOppositions = config.getMinPropositions();

            if (numProposals < minProposals) {
                throw new GameI.BadTransException("Agent proposed " + numProposals
                        + " but should have proposed at least " + minProposals);
            }
            if (numProposals > maxProposals) {
                throw new GameI.BadTransException("Agent proposed " + numProposals
                        + " but should have proposed at most " + maxProposals);
            }

            // Player is not penalized if there aren't enough offered challenge.
            if (getTheirOffered().length() < minOppositions) {
                minOppositions = getTheirOffered().length();
            }
            if (numOppositions < minOppositions) {
                throw new GameI.BadTransException("Agent opposed " + numOppositions
                        + " but should have opposed at least " + minOppositions);
            }
        }
    }

    // private void DontOfferOrAcceptIfOverTime(PlayerTrans trans){
    //
    // if (config.isOverTime(currentRound)) {
    // if (trans.getOfferTrans().length() > 0) {
    // throw new GameI.BadTransException("Offered challenges during overtime
    // rounds");
    // }
    // if (trans.getAcceptTrans().length() > 0) {
    // throw new GameI.BadTransException("accepted challenges during overtime
    // rounds");
    // }
    // }
    // }

    private void reofferFromOthers(PlayerTrans trans){
        boolean allOffered = getTheirOffered().containsAllG(trans.getReofferTrans(),
                Config.<OfferedChallenge, ReofferTrans> getComp());
        if (!allOffered) {
            throw new GameI.BadTransException("Reoffered a challenge not offered by others");
        }
    }

    private void dontAcceptAndReoffer(PlayerTrans trans){
        boolean overlap = trans.getAcceptTrans().containsAnyG(trans.getReofferTrans(),
                new List.GComp<AcceptTrans, ReofferTrans>() {

                    @Override
                    public boolean comp(AcceptTrans a, ReofferTrans r){
                        return a.getChallengeid() == r.getChallengeid();
                    }
                });
        if (overlap) {
            throw new GameI.BadTransException("Reoffered an Accepted Challenge");
        }
    }

    private void checkReoffersDecrement(PlayerTrans trans){
        for (ReofferTrans rt : trans.getReofferTrans()) {
            if(!hasChallenge(getTheirOffered(), rt.getChallengeid()))
                throw new GameI.BadTransException("Reoffered unknown challenge, ID: "+rt.getChallengeid());
                
            double offeredPrice = findChallenge(getTheirOffered(), rt.getChallengeid()).getPrice();
            if (rt.getPrice() >= offeredPrice || rt.getPrice() > 0
                    && Util.lessThan(offeredPrice - rt.getPrice(), config.getMindecr())) {
                throw new GameI.BadTransException("Reoffer by less than mindec (" + (offeredPrice - rt.getPrice())
                        + ")");
            }
        }
    }

    private void solveFromProvided(PlayerTrans trans){
        boolean allSolved = getProvided().sameG(trans.getSolvedTrans(),
                Config.<ProvidedChallenge, SolveTrans> getComp());
        if (!allSolved) {
            throw new GameI.BadTransException("Solved and provided challenges don't match");
        }
    }

    private void provideAllAccepted(PlayerTrans trans){
        boolean same = getAccepted()
                .sameG(trans.getProvidedTrans(), Config.<AcceptedChallenge, ProvideTrans> getComp());
        if (!same) {
            throw new GameI.BadTransException("Didn't provide all problems");
        }
    }

    private void secretChallengesHaveSecrets(PlayerTrans trans){
        for (ProvideTrans proTrans : trans.getProvidedTrans()) {
            int challengeId = proTrans.getChallengeid();
            for (AcceptedChallenge challenge : getAccepted()) {
                if (challenge.getKey() == challengeId) {
                    if (challenge.getKind().isSecret()) {
                        // secret challenge
                        if (!proTrans.getSecret().isSome()) {
                            throw new GameI.BadTransException("Secret not provided for secret challenge: "
                                    + challengeId);
                        }
                    } else {
                        // All challenge
                        if (proTrans.getSecret().isSome()) {
                            throw new GameI.BadTransException("Secret provided for all challenge: " + challengeId);

                        }
                    }
                }
            }
        }
    }


    private void acceptFromOthers(PlayerTrans trans){
        boolean allOffered = getTheirOffered().containsAllG(trans.getAcceptTrans(),
                Config.<OfferedChallenge, AcceptTrans> getComp());
        if (!allOffered) {
            throw new GameI.BadTransException("Accepted a challenge not offered by others");
        }

    }

    /** Offer challenges not in store */
    private void offerNewChallenges(PlayerTrans trans){
        boolean notFresh = getAllOffered().containsAnyG(trans.getOfferTrans(),
                new List.GComp<OfferedChallenge, OfferTrans>() {
                    public boolean comp(OfferedChallenge ch, OfferTrans trans){
                        return ch.getPred().equals(trans.getPred());
                    }
                });
        if (notFresh) {
            throw new GameI.BadTransException("Challenge already in store");
        }
        boolean duplicates = trans.getOfferTrans().containsAny(trans.getOfferTrans(),
                new List.Comp<OfferTrans>() {
                    public boolean comp(OfferTrans t1, OfferTrans t2){
                        return (t1 != t2) && t1.getPred().equals(t2.getPred());
                    }
                });
        if (duplicates) {
            throw new GameI.BadTransException("Offered Duplicate Challenges");
        }
    }

    /** Offer prices in [0..1] */
    private void offerPricesInRange(PlayerTrans trans){
        if (trans.getOfferTrans().contains(new List.Pred<OfferTrans>() {

            @Override
            public boolean huh(OfferTrans t){
                return t.getPrice() < 0 || 1.0 < t.getPrice();
            }
        })) {
            throw new GameI.BadTransException("Offered Price Not in Range");
        }
    }

    /** Offer valid problem types */
    private void offerValidProblemTypes(PlayerTrans trans){
        for (OfferTrans t : trans.getOfferTrans()) {
            Option<String> error = config.getPredicate().valid(t.getPred());
            if (error.isSome()) {
                throw new GameI.BadTransException("Illegal Type Offered:" + error.inner() + ". Given: " + t.getPred());
            }
        }
    }
    
    /** Provide valid problems*/
    private void provideCorrectProblems(PlayerTrans trans){
        for (ProvideTrans proTrans : trans.getProvidedTrans()) {
            Problem problem = proTrans.getInst();
            int challengeId = proTrans.getChallengeid();
            for (AcceptedChallenge challenge : getAccepted()) {
                if (challenge.getKey() == challengeId) {
                    Option<String> res = config.getPredicate().valid(problem, challenge.getPred());
                    if (res.isSome()) {
                        throw new GameI.BadTransException("Invalid Problem: " + res.inner());
                    }
                }
            }
        }
    }

    /** Check that the correct player has responded */
    private void currentPlayerResponded(PlayerTrans trans){
        if (!getId().equals(trans.getId())) {
            throw new GameI.BadTransException("Incorrect Player Responded");
        }
    }
   /** Is the Challenge ID in the given List */
    static <CH extends Challenge> boolean hasChallenge(List<CH> lst, final int chID){
        return lst.contains(new List.Pred<CH>() {

            @Override
            public boolean huh(CH ch){
                return ch.getKey() == chID;
            }
        });
    }
    /** Find the given Challenge ID in the given List */
    static <CH extends Challenge> CH findChallenge(List<CH> lst, final int chID){
        return lst.find(new List.Pred<CH>() {

            @Override
            public boolean huh(CH ch){
                return ch.getKey() == chID;
            }
        });
    }
    

    /** DGP method from Class PrintHeapToString */
    public String toString(){ return scg.gen.PrintHeapToString.PrintHeapToStringM(this); }
    /** Getter for field PlayerContext.statement */
    public Option<AccountTransactionList> getStatement(){ return statement; }
    /** Getter for field PlayerContext.solved */
    public List<SolvedChallenge> getSolved(){ return solved; }
    /** Getter for field PlayerContext.provided */
    public List<ProvidedChallenge> getProvided(){ return provided; }
    /** Getter for field PlayerContext.accepted */
    public List<AcceptedChallenge> getAccepted(){ return accepted; }
    /** Getter for field PlayerContext.theirOffered */
    public List<OfferedChallenge> getTheirOffered(){ return theirOffered; }
    /** Getter for field PlayerContext.ourOffered */
    public List<OfferedChallenge> getOurOffered(){ return ourOffered; }
    /** Getter for field PlayerContext.currentRound */
    public int getCurrentRound(){ return currentRound; }
    /** Getter for field PlayerContext.balance */
    public double getBalance(){ return balance; }
    /** Getter for field PlayerContext.id */
    public PlayerID getId(){ return id; }
    /** Getter for field PlayerContext.config */
    public Config getConfig(){ return config; }
    /** Compute a HashCode for this PlayerContext */
    public int hashCode(){
        return ((config).hashCode()+(3 * (id).hashCode())+(5 * ((Double)balance).hashCode())+(7 * ((Integer)currentRound).hashCode())+(9 * (ourOffered).hashCode())+(11 * (theirOffered).hashCode())+(13 * (accepted).hashCode())+(15 * (provided).hashCode())+(17 * (solved).hashCode())+(19 * (statement).hashCode()));
    }

}


