// ** This class was generated with DemFGen (vers:11/17/2009)

package scg.gen;

import java.io.*;
import edu.neu.ccs.demeterf.lib.*;
import scg.Util;
import scg.game.*;
import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.evergreen.ir.RelationCore;




/** Representation of BooleanMaxCSPPredicate */
public abstract class BooleanMaxCSPPredicate implements Predicate{
    protected final int maxClauses;

    /** Construct a(n) BooleanMaxCSPPredicate Instance */
    public BooleanMaxCSPPredicate(int maxClauses){
        this.maxClauses = maxClauses;
    }
    /** Parse an instance of BooleanMaxCSPPredicate from the given String */
    public static BooleanMaxCSPPredicate parse(String inpt) throws ParseException{
        return new TheParser(new java.io.StringReader(inpt)).parse_BooleanMaxCSPPredicate();
    }
    /** Parse an instance of BooleanMaxCSPPredicate from the given Stream */
    public static BooleanMaxCSPPredicate parse(java.io.InputStream inpt) throws ParseException{
        return new TheParser(inpt).parse_BooleanMaxCSPPredicate();
    }
    /** Parse an instance of BooleanMaxCSPPredicate from the given Reader */
    public static BooleanMaxCSPPredicate parse(java.io.Reader inpt) throws ParseException{
        return new TheParser(inpt).parse_BooleanMaxCSPPredicate();
    }

    /** Field Class for BooleanMaxCSPPredicate.maxClauses */
    public static class maxClauses extends edu.neu.ccs.demeterf.Fields.any{}

    /** No duplicate relation numbers, Only rank 3 relations are allowed */
    public Option<String> valid(ProblemType pred){
        List<Integer> type = pred.getType().toList();
        if (type.contains(new List.Pred<Integer>() {

            @Override
            public boolean huh(Integer i){
                return i < 0 || i > 255;
            }
        })) {
            return Option.some("Non-Rank 3 relations found");
        }
        return Option.none();
    }

    /** Is this a valid/well-formed Problem of the given Type? */
    public Option<String> valid(Problem inst, ProblemType pred){
        // Check instance size.
        if (inst.getClauses().length() > maxClauses) {
            return Option.some("Too Many Clauses [" + inst.getClauses().length() + "]");
        }
        if (inst.getVars().length() > maxClauses) {
            return Option.some("Too Many Variables [" + inst.getVars().length() + "]");
        }
        // Only vlaid relation numbers are used
        ListSet<Integer> validRelationNumbers = pred.getType();
        for (Clause clause : inst.getClauses()) {
            if (!validRelationNumbers.contains(clause.relnum)) {
                return Option.some("Incorrect Type");
            }
        }
        // The constraint that all variables are declared should be checked
        // while parsing
        for (Clause clause : inst.getClauses()) {
            // Only clauses of degree 3 are allowed
            if (clause.getVars().length() != 3) {
                return Option.some("Only 3 variables are allowed in a clause");
            }
            // No duplicates
            if (!(clause.getVars().removeDuplicates().length() == clause.getVars().length())) {
                return Option.some("Clause contains duplicated Variables");
            }
            // Weights must be greater than zero
            if (clause.getWeight() <= 0) {
                return Option.some("Clause weight must be greater than zero");
            }
            // All Vars must be declared
            for (Var var : clause.vars) {
                if (!inst.getVars().contains(var)) {
                    return Option.some("Undeclared Variable in Clauses");
                }
            }
        }
        return Option.none();
    }


    /** DGP method from Class PrintHeapToString */
    public String toString(){ return scg.gen.PrintHeapToString.PrintHeapToStringM(this); }
    /** Getter for field BooleanMaxCSPPredicate.maxClauses */
    public abstract int getMaxClauses();
}


