package scg.game;

import java.io.IOException;
import java.util.Date;

import scg.gen.ProblemType;

public class StatisticsCollector extends HistoryFile {

    public StatisticsCollector(String prefix, Date compTime, String suffix) throws Exception {
        super(prefix, compTime, suffix);
    }

    public void startStatisticsCollection() throws IOException{
        history.write("<html><head><title>History Statistics</title></head><body><table>\n");
        history.write("    <tr><th>id</th> <th>offerer</th> <th>acceptor</th> <th>pred</th> <th>price</th> <th>quality</th> <th>secretQuality</th> <th>profit(offerer)</th></tr>\n");
    }

    public void collectStatistic(int challengeId, String offerer, String acceptor, ProblemType problem, double price,
            double quality, double secretQuality, double profit){
        String msg = "    <tr><td>" + challengeId + "</td><td>" + offerer + "</td><td>" + acceptor + "</td><td>" + problem + "</td><td>" + price + "</td><td>"
                + quality + "</td><td>" + secretQuality + "</td><td>" + (price - profit) + "</td></tr>\n";
        try {
            history.write(msg);
        } catch (IOException e) {
            System.err.println("Failed to collect statistics!");
        }
    }

    public void finishStatisticsCollection() throws IOException{
        history.write("</table></html>\n");
        history.flush();
        history.close();
    }

}
