package scg.game;

import scg.Constants;
import scg.gen.PlayerContext;
import scg.gen.PlayerSpec;
import scg.gen.PlayerTrans;
import edu.neu.ccs.demeterf.http.classes.HTTPReq;
import edu.neu.ccs.demeterf.http.classes.HTTPResp;

/**
 * An extra level of indirection supporting both distributed and direct
 * Admin/Player interactions
 */
public abstract class PlayerProxy implements PlayerProxyI {

    /** The Player we are a proxy for */
    private final PlayerSpec spec;

    /** Create a Proxy for the given PlayerSpec */
    public PlayerProxy(PlayerSpec sp) {
        spec = sp;
    }

    /** Return the PlayerSpec this proxy represents */
    public PlayerSpec getSpec(){
        return spec;
    }

    public String getName(){
        return getSpec().getName();
    }

    public String getAddress(){
        return getSpec().getName();
    }

    /** Take the Player turn by contacting the player and getting its response */
    public PlayerTrans takeTurn(PlayerContext currentPlayerContext){
        HTTPReq req = null;
        HTTPResp resp = null;
        try {
            req = HTTPReq.Post(Constants.PLAYER_PATH_ENTRY, currentPlayerContext.toString());
            resp = null;
            resp = contactPlayer(req, currentPlayerContext.getConfig().getTurndur());
        }catch(Exception e) {
            throw new GameI.HTTPTransException(req, resp, e);
        }
        if (resp.isError())
            throw new GameI.HTTPTransException(req, resp, resp.getBodyString());
            
        try {
            return PlayerTrans.parse(resp.getBodyString());
        } catch (scg.gen.ParseException e) {
            throw new GameI.HTTPTransException(req, resp, e);
        }
    }

    /** The go-between method: Request -> Response */
    public abstract HTTPResp contactPlayer(HTTPReq req, int timeout);
}
