package scg.game;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;

import scg.Util;
import scg.game.Game.PlayerStore;
import scg.gen.Event;
import scg.gen.RevealEvent;
import scg.gen.PlayerID;
import scg.gen.PlayerSpec;
import scg.gen.PlayerResult;
import scg.gen.KickedStar;
import scg.gen.Round;
import scg.gen.Solution;
import scg.gen.Var;
import edu.neu.ccs.demeterf.lib.Entry;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.ident;
import edu.neu.ccs.demeterf.lib.Option;

/**  */
public class HistoryFile {

    /**  */
    private final String historyFile;
    /**  */
    protected final Writer history;
    /**  */
    private boolean headerPrinted = false;

    /**  */
    public HistoryFile(String prefix, Date compTime, String suffix) throws Exception {
        this.historyFile = prefix + Util.getFileNameSafeDate(compTime) + suffix;
        File f = new File(historyFile);
        if (!f.exists()) {
            f.createNewFile();
        }
        this.history = new OutputStreamWriter(new FileOutputStream(f));
    }

    public void header(edu.neu.ccs.demeterf.lib.List<Entry<PlayerID, PlayerSpec>> players) throws IOException{
        if (headerPrinted) {
            throw new RuntimeException("Header can be printed only once");
        }
        history.append(players.toString("\n", "  "));
        history.append("\n\n");
        history.flush();
        headerPrinted = true;
    }

    /**  */
    private int round = -1;
    /**  */
    private List<Event> roundEvents = List.create();

    /**  */
    public void startRound(int numRound){
        round = numRound;
        roundEvents = List.create();
    }

    /**  */
    public void flushRound() throws IOException{
        Round r = new Round(round, roundEvents.reverse());
        history.append(r.toString() + "\n");
        history.flush();
        round = -1;
    }

    /**  */
    public void recordEvent(int playerID, Event event){
        if (round == -1) {
            throw new RuntimeException("Can record events in the context of a round only");
        }
        this.roundEvents = this.roundEvents.push(event);
    }

    /**  */
    public void footer(java.util.List<PlayerStore> players) throws IOException{
        history.append("\n**** Final Results *****");
        history.append(Util.toDemF(players).map(new List.Map<PlayerStore, PlayerResult>() {
            KickedStar star = new KickedStar();
            @Override
            public PlayerResult map(PlayerStore f){
                return new PlayerResult(f.getSpec().getName(),
                        (f.wasKicked()?Option.some(star):Option.<KickedStar>none()),f.account);
            }
        }).toString());
    }

    /**  */
    public void tournamentResults(Tournament t) throws IOException{
        history.append("**** Final Tournament Results *****\n");
        history.append(t.toString());
    }

    public void recordCompetionEvent(String msg) throws IOException{
        history.append(msg);
    }

    public void close() throws IOException{
        history.flush();
        history.close();
    }

    public void secretRevealedEvent(int challengeID, Solution solution) throws IOException{
        roundEvents = roundEvents.push(new RevealEvent(challengeID,solution.getAssign().toList()));
    }
}
