package scg.game;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

import scg.Util;
import scg.gen.AcceptTrans;
import scg.gen.AccountTransaction;
import scg.gen.OfferTrans;
import scg.gen.ProvideTrans;
import scg.gen.ReofferTrans;
import scg.gen.SolveTrans;
import edu.neu.ccs.demeterf.http.classes.HTTPReq;
import edu.neu.ccs.demeterf.http.classes.HTTPResp;

/** Interface representation of GameI */
public interface GameI {

    /** Handle an offer challenge transaction */
    OfferTrans installTransaction(int challengerID, OfferTrans ot);

    /** Handle an accept challenge transaction */
    AcceptTrans installTransaction(int challengeeID, AcceptTrans at);

    /** Handle Provide Transactions */
    ProvideTrans installTransaction(int challengerID, ProvideTrans pt);

    /** Handle Solve Transactions */
    SolveTrans installTransaction(int challengeeID, SolveTrans st);

    /** Handle Reoffer Transactions */
    ReofferTrans installTransaction(int newChallenger, ReofferTrans rt);

    /**
     * Apply transaction and add a transaction to both player's account
     * statements
     */
    void addPlayerAccountTransaction(AccountTransaction accountTrans);

    /**
     * Transfer money between player accounts. Designed to be invoked only from
     * within AccountTransaction
     */
    void transferMoney(int fromPlayerId, int toPlayerId, double amount);

    /** Transaction is invalid for some reason */
    public static class BadTransException extends RuntimeException {

        public BadTransException(String s) {
            super(s);
        }
    }

    /** Errors within HTTP */
    public static class HTTPTransException extends RuntimeException {

        HTTPReq req;
        HTTPResp resp;

        public HTTPTransException(HTTPReq rq, HTTPResp rsp, Exception cause) {
            super(cause);
            req = rq;
            resp = rsp;
        }
        public HTTPTransException(HTTPReq rq, HTTPResp rsp, String cause) {
            super(cause);
            req = rq;
            resp = rsp;
        }

        /** Save HTTP interactions? */
        private static java.io.PrintStream save = null;

        /** Save HTTP responses? */
        public static void setSaveFile(String file) throws IOException{
            save = new PrintStream(new FileOutputStream(file));
        }

        /** Log the Exception to the file */
        public void storeException(String player){
            if (save == null) {
                return;
            }
            Throwable e = Util.rootCause(this);
            String stack = "";
            for(StackTraceElement stk:e.getStackTrace())
                stack += "    "+stk.toString()+"\n";
            save.println("************ EXCEPTION[" + player + "]: "+e.getClass().getName()+" *************\n"
                    + "------------------ REQUEST ------------------------\n"
                    + req + "\n------------------ RESPONSE -----------------------\n"
                    + resp + "\n------------------  STACK  ------------------------\n"
                    + stack + "************ END[" + player + "] *************\n");
            save.flush();
        }
    }
}
