/* CLI.java
 * Bryan Chadwick :: 2007
 * Cammand Line Utility methods/functions */

package edu.neu.ccs.demeterf.util;
import edu.neu.ccs.demeterf.lib.List;

/** CLI Utility Class for parsing arguments etc. */
public class CLI {
    private CLI(){}
    
    /** Arguments index within the array returned from <tt>splitArgs</tt> */
    public static int ARGS = 0;
    /** Options index within the array returned from <tt>splitArgs</tt> */
    public static int OPTS = 1;
    /** Takes an array of strings (presumably from the command-line) and separates
     *    them into Options and Argsuments. Options begin with '-', but I prefer "--"
     *    so they stick out a little more.  
     *    See {@link edu.neu.ccs.demeterf.demfgen.classes.DemFGenMain DemFGenMain}
     *    and {@link edu.neu.ccs.demeterf.inline.Inline Inline} for examples. */
    public static List<String>[] splitArgs(String[] args){
        List<String> e = List.create();
        List<String>[] opts = new List[]{e,e};
        
        for(String s:args){
          if(s.startsWith("-"))
              opts[OPTS] = opts[OPTS].push(s);
          else
              opts[ARGS] = opts[ARGS].push(s);
        }
        opts[ARGS] = opts[ARGS].reverse();
        return opts;
    }
    /** Returns the seperated list that makes up a command-line option of the
     *    form: <tt>"--name:A:B:C"</tt>.  For this command-line option this method will
     *    return: <tt>new String[]{"A","B","C"}</tt>  */
    public static String[] separateOption(String name, List<String> opts){
        String arg = getArgument(name,opts);
        if(arg.length() == 0)return new String[0];
        return arg.split(":");
    }
    /** Returns the Argument part of an Option of the form '--option:argument' */
    public static String getArgument(String name, List<String> opts){
        final String pre = (name.startsWith("--")?"":"--")+name+":"; 
        int i = opts.index(new List.Pred<String>(){
            public boolean huh(String s){ return s.startsWith(pre); } 
        });
        if(i >= 0)
            return opts.lookup(i).substring(pre.length());
        return "";
    }
    /** Determine whether or not the option is set */
    public static boolean optionSet(String name, List<String> opts){
        final String pre = (name.startsWith("--")?"":"--")+name; 
        int i = opts.index(new List.Pred<String>(){
            public boolean huh(String s){ return s.startsWith(pre); } 
        });
        return (i >= 0);
    }
    /** Return the invalid options from the List, where Valid option prefixes are given */
    public static List<String> invalidOptions(List<String> opts, final List<String> valid){
        return opts.filterout(new List.Pred<String>(){
            public boolean huh(String s){
                int i = s.indexOf(':');
                return valid.contains(s.substring(0,i>=0?i:s.length()));
            }
        });
    }
}