package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;

/** Represents an Optional instance that exists. */
public class Some<X> extends Option<X>{
    protected final X just;
    public Some(X just){ this.just = just; }
    
    public boolean isSome(){ return true; }
    public X inner(){ return just; }
    public <Y> Option<Y> apply(List.Map<X,Y> m){
        return Option.<Y>some(m.map(just));
    }
    
    public boolean equals(Object o){
        if(!(o instanceof Some))return false;
        Some oo = (Some)o;
        return (((Object)just).equals(oo.just));
    }
    public String toString(){ return "Some("+just+")"; }
    
    public static class just extends Fields.any{}
    
    public X getJust(){ return just; }
}

