package edu.neu.ccs.demeterf.lib;

/** Represents an Optional instance, similar to ML/Haskell Option types. Subclasses
 *    Some/None should not be used directly, please Option.<X>some(...) and
 *    Option.<X>none() to create them. */
public abstract class Option<X>{
    /** Create an Option that exists. */
    public static <X> Option<X> some(X x){ return new Some<X>(x);}
    /** Create an Option that is not there (nothing) */
    public static <X> Option<X> none(){ return new None<X>();}
    /** Does this Option exist? */
    public abstract boolean isSome();
    /** Get the inner instance that this Option contains */
    public abstract X inner();
    
    /** Apply a function to the contained object in this Option if it exists */
    public abstract <Y> Option<Y> apply(List.Map<X,Y> m);
    
}

