package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;

import java.util.Comparator;

/** Represents a Map of comparable Keys to any old Values, implemented with RBTrees.
 *    The Key requires a Comparator<Key>, but if Key is Comparable, you can simply
 *    supply the type to the createor functions. Also see <tt>Map.Entry</tt>. */
public class ListMap<Key, Val> implements Iterable<Entry<Key,Val>>{
    protected final List<Entry<Key,Val>> list;
    private final Comparator<Key> comp;
    
    /** Field Class */
    public static class list extends Fields.any{}
    
    /** Function Class to help in the merging of Maps.  Merges Values associated to
     *    the same Key when calling merge(...). */
    public static abstract class Merge<Val>{ public abstract Val merge(Val a, Val b); }
    
    /** Trnasformer for Values of a given Map */
    public static abstract class Transform<X,Y>{ public abstract Y transform(X x); }
    
    class Transformer<NV> extends List.Map<Entry<Key,Val>, Entry<Key,NV>>{
        List.Map<Val,NV> tr;
        Transformer(List.Map<Val,NV> trr){ tr = trr; }
        public Entry<Key,NV> map(Entry<Key,Val> e){
            return Entry.<Key,NV>create(e.key, tr.map(e.val), comp);
        }
    }
    /** Transform Each of the Keys */
    public <NVal> ListMap<Key,NVal> transformValues(final List.Map<Val,NVal> tr){
        return ListMap.<Key,NVal>create(toList().map(new Transformer<NVal>(tr)),comp);
    }
    
    /** Create an Empty Map of *Comparable* Elements. */
    private ListMap(){ this(List.<Entry<Key,Val>>create(), new Entry.CComp<Key>()); }
    /** Create an Empty Map using the given Comparator to compare elements. */
    private ListMap(Comparator<Key> c){ this(List.<Entry<Key,Val>>create(), c); }
    /** Create a Map from the given list of Entries using the given Comparator. */    
    private ListMap(Comparator<Key> c, List<Entry<Key,Val>> l){ list = l; comp = c; }
    
    /** Create a Map from the given list of Entries. The <tt>Key</tt> <b>must</b> implement
     *    <tt>Comparable&lt;Key&gt;</tt>*/
    public ListMap(List<Entry<Key,Val>> l){ this(l, new Entry.CComp<Key>()); }
    /** Create a Map from the given list of Entries. The <tt>Key</tt> <b>must</b> implement
     *    <tt>Comparable&lt;Key&gt;</tt>*/
    public ListMap(List<Entry<Key,Val>> l, Comparator<Key> c){
        this(c,l.removeDuplicates(new Entry.EComp<Key,Val>(c)).sort(new Entry.LComp<Key,Val>(c)));
    }
    
    /** Create an Empty Map of *Comparable* Elements. */
    public static <Key extends Comparable<Key>,Val> ListMap<Key,Val> create(){ return new ListMap<Key,Val>(); }
    /** Create an Empty Map using the given Comparator to compare elements. */
    public static <Key,Val> ListMap<Key,Val> create(Comparator<Key> c){
        return new ListMap<Key,Val>(c);    
    }
    /** Create a Map from the given list of Entries, with the given Comparator. */    
    public static <Key,Val> ListMap<Key,Val> create(List<Entry<Key,Val>> l, Comparator<Key> c){
        return new ListMap<Key,Val>(l,c);
    }
    /** Create a Map from the given list of Entries using the given Comparator. */    
    public static <Key extends Comparable<Key>,Val> ListMap<Key,Val> create(List<Entry<Key,Val>> es){
        return create(es, new Entry.CComp<Key>());
    }
    /** Create a Map from the given list of Key's and Values. */    
    public static <Key extends Comparable<Key>,Val> ListMap<Key,Val> create(List<Key> ks, List<Val> vs){
        return create(ks,vs, new Entry.CComp<Key>());
    }
    
    static class Zipper<K,V> extends List.Zip<K, V, Entry<K,V>>{
        Comparator<K> c;
        Zipper(Comparator<K> cc){ c = cc; }
        public Entry<K,V> zip(K k, V v){ return Entry.create(k, v, c); }
    }
    /** Create a Map from the given list of Entries using the given Comparator. */    
    public static <Key,Val> ListMap<Key,Val> create(List<Key> ks, List<Val> vs, final Comparator<Key> c){
        return create(ks.zip(new Zipper<Key,Val>(c), vs), c);
    }
    
    static class HashComp<Key> implements Comparator<Key>{
        public int compare(Key k1, Key k2){
            return k1.hashCode()-k2.hashCode();
        }
    }
    /** Create a Map that uses Hashcode to compare Keys. */
    public static <Key,Val> ListMap<Key,Val> hashMap(){
        return new ListMap<Key,Val>(new HashComp<Key>());
    }
    /** Create a Map from the given Entry List that uses Hashcode to compare Keys. */
    public static <Key,Val> ListMap<Key,Val> hashMap(List<Entry<Key,Val>> l){
        return new ListMap<Key,Val>(l, new HashComp<Key>());
    }
    /** Create a Map from the given Key and Value Lists that uses Hashcode to compare Keys. */
    public static <Key,Val> ListMap<Key,Val> hashMap(List<Key> ks, List<Val> vs){
        return create(ks,vs, new HashComp<Key>());
    }
    /** Create a Map from the given Java HashMap. */
    public static <Key,Val> ListMap<Key,Val> hashMap(java.util.Map<Key, Val> hash){
        ListMap<Key,Val> m = ListMap.<Key,Val>hashMap();
        for(java.util.Map.Entry<Key, Val> ent : hash.entrySet())
            m = m.put(ent.getKey(), ent.getValue());
        return m;
    }
    
    
    /** Create a Map from the given List of Entries using the current Comparator. */
    private ListMap<Key,Val> make(List<Entry<Key,Val>> l){ return new ListMap<Key,Val>(l,comp); }
    
    /** Return the number of elements in this Map */
    public int size(){ return list.length(); }
    /** Does this Map contain the given Key? */
    public boolean containsKey(Key k){ return list.contains(new Entry.KPred<Key,Val>(k,comp)); }
    /** Is this Map Empty? */
    public boolean isEmpty(){ return list.isEmpty(); }
    /** Return a new Map with the given Mapping (Entry) added. */
    public ListMap<Key,Val> put(Key k, Val v){
        if(list.contains(new Entry.KPred<Key,Val>(k,comp)))return this;
        return make(list.insert(Entry.create(k,v,comp), new Entry.LComp<Key,Val>(comp))); }
    /** Return a new Map with the given Mapping added or updated if it exists. */
    public ListMap<Key,Val> remap(Key k, Val v){
        Entry<Key,Val> e = Entry.create(k,v,comp);
        return make(!containsKey(k)?list.insert(e, new Entry.LComp<Key,Val>(comp)):
            list.replace(new Entry.KPred<Key,Val>(e.getKey(),comp),e));
    }
    /** Get the Value that the given Key is mapped to. */
    public Val get(Key k){ return list.find(new Entry.KPred<Key,Val>(k,comp)).val; }
    /** Return a new Map that does not include the given key */
    public ListMap<Key,Val> remove(Key k){ return make(list.remove(new Entry.KPred<Key,Val>(k,comp))); }
    
    class InList extends List.Pred<Entry<Key,Val>>{
        List<Entry<Key,Val>> l;
        InList(List<Entry<Key,Val>> ll){ l = ll; }
        public boolean huh(Entry<Key,Val> e){ return l.contains(new Entry.KPred<Key,Val>(e.getKey(),comp)); }
    }
    /** Merge the given Map into this one, ignoring duplicate mappings. */
    public ListMap<Key,Val> merge(ListMap<Key,Val> s){
        return make(list.insert(s.list.filter(new InList(list)), new Entry.LComp<Key,Val>(comp)));
    }
    
    class Merger extends List.Fold<Entry<Key,Val>, List<Entry<Key,Val>>>{
        Merge<Val> m;
        Merger(Merge<Val> mm){ m = mm; }
        public List<Entry<Key,Val>> fold(Entry<Key,Val> e, List<Entry<Key,Val>> l){
            if(!l.contains(new Entry.KPred<Key,Val>(e.getKey(),comp)))
                return l.insert(e, new Entry.LComp<Key,Val>(comp));
            return l.replace(new Entry.KPred<Key,Val>(e.getKey(),comp),
                    Entry.create(e.getKey(),m.merge(e.val,l.find(new Entry.KPred<Key,Val>(e.getKey(),comp))
                            .getVal()),comp));
        }
    }
    /** Merge the given Map into this one, using the given Merge function object
     *    to merge the elements of matching Keys */
    public ListMap<Key,Val> merge(ListMap<Key,Val> s, final Merge<Val> m){
        return make(s.list.fold(new Merger(m), list));
    }
    /** Merge the given Map into this one, using the given Merge function object
     *    to merge the elements of matching Keys */
    public ListMap<Key,Val> merge(Key k, Val v, final Merge<Val> m){
        Entry<Key,Val> e = Entry.create(k,v,comp); 
        if(!containsKey(e.getKey()))
            return make(list.insert(e, new Entry.LComp<Key,Val>(comp)));
        return make(list.replace(new Entry.KPred<Key,Val>(e.getKey(),comp),
                Entry.create(e.key,m.merge(v,list.find(new Entry.KPred<Key,Val>(e.getKey(),comp)).getVal()),comp)));
    }
    
    class Keyer extends List.Map<Entry<Key,Val>,Key>{
        public Key map(Entry<Key,Val> e){ return e.getKey(); }
    }
    /** Reutrn a List of the Keys contained in this Map. */
    public List<Key> keys(){ return toList().map(new Keyer()); }
    
    class Valer extends List.Map<Entry<Key,Val>,Val>{
        public Val map(Entry<Key,Val> e){ return e.getVal(); }
    }
    /** Reutrn a List of the Values contained in this Map. */
    public List<Val> values(){ return toList().map(new Valer()); }
    /** Return all the Entries in this Map as a list, in Key order. */
    public List<Entry<Key,Val>> toList(){ return list; }
    /** Return an Iterator over the Entries in this Map, in Key order. */
    public java.util.Iterator<Entry<Key,Val>> iterator(){ return toList().iterator(); }
    /** Produce a String representation of this Map. */
    public String toString(){ return "[ "+toList().toString(" ","")+" ]"; }
    
    /** Convert this Map into a java.util.Map */
    public java.util.Map<Key, Val> toJavaMap(){
        java.util.Map<Key,Val> m = new java.util.HashMap<Key,Val>();
        for(Entry<Key,Val> e:this)m.put(e.getKey(), e.getVal());
        return m;
    }
    
    /** Is this Map the same as the given Object? */
    public boolean equals(Object o){
        if(!(o instanceof ListMap))return false;
        ListMap oo = (ListMap)o;
        return (list.length() == oo.list.length() &&
                list.equals(oo.list));
    }
    /** Retur this Maps HashCode */
    public int hashCode(){ return 3*list.hashCode(); }
}
