package edu.neu.ccs.demeterf.http;

import edu.neu.ccs.demeterf.http.server.*;
import edu.neu.ccs.demeterf.http.classes.*;
import edu.neu.ccs.demeterf.lib.*;
import java.io.*;

/** Test Server response class */
public class ClientTest{
    public HTTPResp fileResp(HTTPReq req){
        String file = req.getHead().getUrl().trimArgs();
        if(!file.startsWith("/file/"))
            return HTTPResp.textError("ERROR: Unknown Request");
        file = file.substring(file.indexOf('/',1));
        try{
            BufferedReader buff = new BufferedReader(new FileReader(file));
            StringBuffer sb = new StringBuffer();
            String line = "";
            while((line = buff.readLine()) != null)
                sb.append(line).append('\n');
            return HTTPResp.textResponse(sb.toString());
        }catch(IOException e){
            return HTTPResp.error("FileNotFound: \'"+file+"\'");
        }
    }
    
    static void p(String s){ System.err.print(s); }
    public static void main(String[] args) throws Exception{
        HTTPResp resp = HTTPReq.Get("/file/"+args[0]).send(args[1], 9000);
        System.out.println("LENGTH: "+resp.getHeaders().get("Content-Length"));
        System.out.println("  REAL: "+resp.getBodyString().length());
    }
}
