package edu.neu.ccs.demeterf.dispatch;

import edu.neu.ccs.demeterf.lib.List;

/** A Predicate over DBEntries: Is the given DBEntry applicable to
 *   this array of Types (arguments)? */
public class TypePred<M> extends List.Pred<DBEntry<M>>{
    Class<?> subType;
    int argNum;
    TypePred(Class<?> c, int i){ argNum = i; subType = c; }
    
    public boolean huh(DBEntry<M> e){
        return huh(e, subType, argNum);
    }
    public static <M> boolean huh(DBEntry<M> e, Class<?> c, int i){
        return ((e.numArgs() <= i) || e.arg(i).isAssignableFrom(c));
    }
}