/* Edge.java
 * Bryan Chadwick :: 2007
 * Represents Outgoing Edges */

package edu.neu.ccs.demeterf.control;

import java.lang.reflect.Field;
import edu.neu.ccs.demeterf.util.Util;

/** Represents Outgoing Edges within a ClassGraph (class hierarchy). The edges
 *   are represented by a class and a fields name (String). During construction
 *   we can check to be sure that the edge/field exists actually in the class */
public class Edge{
    private static boolean check = true;
    Class<?> host;
    String field;
    
    /** Give the Class and the Field Name */
    public Edge(Class<?> h, String fn){
        if(check){
            boolean good = false;
            for(Field f:Util.getFuncFields(h)){
                if(f.getName().equals(fn)){
                    good = true;
                    break;
                }
            }
            if(!good)
                throw new RuntimeException("Invalid Edge Specified: "+
                        h.getSimpleName()+"."+fn);
        }   
        host = h; field = fn;
    }
    public boolean equals(Object o){
        if(!(o instanceof Edge))return false;
        Edge e = (Edge)o;
        return (host.equals(e.host) && 
                field.equals(e.field));
    }
    public Class<?> getHost(){ return host; }
    public String getFieldName(){ return field; }
    
    static class Fake extends Edge{
        String fakehost;
        Fake(String cls, String fld){
            super(null,fld);
            fakehost = cls;
        }
        public boolean equals(Object o){
            if(!(o instanceof Edge))return false;
            Edge e = (Edge)o;
            return (host.equals(e.host) && 
                    field.equals(e.field));
        }        
    }
    
    public static Edge fakeEdge(final String cls, final String fld){
        return new Fake(cls,fld);
    }
}
