package edu.neu.ccs.demeterf;

/** Represents a containment class for Fields 
 *    We encode seperate argument paths with inner classes that extend
 *    <code>Fields.any</code>.
 */
public class Fields {
    public static Fields.any any = new Fields.any();
    /** Base Field class that represents the pending traversal of any field.
     *   <p>During traversal, {@link edu.neu.ccs.demeterf.FC Function Classes}
     *   implement <tt>update<tt> methods that motify traversal arguments. The second
     *   parameter to these methods should be a subclass of <tt>Fields.any</tt> that
     *   represents the field about to be traversed. 
     *   </p>
     *   
     *   We use the encoding that a class <tt>C</tt> with field <tt>F</tt> should
     *   contain an inner <tt>public static class</tt> with the same name as the
     *   field name:
     *   <style type='text/css'>                                                                    
     *     .def{ color: #000000; }                                                                 
     *     .grade{                                                                                 
     *       border: solid #FF0000 1px;                                                           
     *       background-color: #FFFF60;                                                           
     *     }                                                                                       
     *     .gcom{ font-weight: bold; background-color: #FFC0C0; }                                  
     *     .com{ font-style: italic; color: #880000; }                                             
     *     .keyw{ font-weight: bold; color: #000088; }                                             
     *     .num{ color: #00AA00; }                                                                 
     *     .func{ color: #BB7733; }                                                                
     *     .str{ color: #CC00AB; }                                                                 
     *     .prim{ color: #0000FF; }                                                                
     *   </style>                                                                                   
     *   <blockquote><code><pre>                                                                              
     *   <span class="com">// Class definition for C</span><span class="def">                                                                        
     *   </span><span class="keyw">public</span><span class="def"> </span><span class="keyw">class</span><span class="def"> C{                                                       
     *      </span><span class="com">// Single Field... F</span><span class="def">         
     *      </span><span class="prim">String</span><span class="def"> F;                   
     *                                                                                     
     *      </span><span class="com">// Constructor</span><span class="def">               
     *      </span><span class="keyw">public</span><span class="def"> </span><span class="func">C</span><span class="def">(</span><span class="prim">String</span><span class="def"> F){ </span><span class="keyw">this</span><span class="def">.F = F; }                      
     *                                                                                     
     *      </span><span class="com">// Field class definition</span><span class="def">    
     *      </span><span class="keyw">public</span><span class="def"> </span><span class="keyw">static</span><span class="def"> </span><span class="keyw">class</span><span class="def"> F </span><span class="keyw">extends</span><span class="def"> Fields.any{}             
     *   }</span>
     *   </pre></code></blockquote>
     *   
     *   <p>See {@link edu.neu.ccs.demeterf.examples.NewUpdate NewUpdate} for an example of
     *   how the field definition can be used during traversal.</p>
     */
    public static class any{}
}
