package player.tasks;

import logging.Logger;
import scg.gen.*;
import scg.Util;
import edu.neu.ccs.demeterf.lib.*;

/** Solve the provided Problem instances ASAP */
public class SolveTask {

    protected final Logger log;

    /** Create a SolveTask with the given Logger */
    public SolveTask(Logger l){ log = l; }

    /** Solve provided Problem instances */
    public List<Transaction> solve(List<ProvidedChallenge> chs, final double factor, long start){
        return chs.map(new List.Map<ProvidedChallenge, Transaction>(){
            public Transaction map(ProvidedChallenge ch)
            { return solve(ch, factor); }
        });
    }
    
    /** Do the actual solving of Problem instances */
    public SolveTrans solve(ProvidedChallenge ch, double factor){
        log.notify("Solving : #" + ch.getKey());
        return new SolveTrans(solve(ch, ch.getPrice(), factor), ch.getKey());
    }

    /** Solve the given Problem Instance */
    protected Solution solve(ProvidedChallenge ch, double price, double factor){
        return new Solution(Map.create(randomAssign(ch.getInstance().getVars(), Util.random())));
    }

    /** Random Assignment to each of the variables */
    public static List<Entry<Var, Boolean>> randomAssign(List<Var> vs, final double bias){
        return vs.map(new List.Map<Var, Entry<Var, Boolean>>() {
            public Entry<Var, Boolean> map(Var v){
                return Entry.create(v, Util.coinFlip(bias));
            }
        });
    }
}
