package player.tasks;

import logging.Logger;
import scg.Util;
import scg.gen.Config;
import scg.gen.OfferedChallenge;
import scg.gen.ReofferTrans;
import edu.neu.ccs.demeterf.lib.List;

/** Reoffer all of the other Players Challenges at lower prices */
public class ReofferTask {

    protected final Logger log;

    /** Create a ReofferTask with the given Logger */
    public ReofferTask(Logger l){ log = l; }

    /** Choose a random one to Reoffer... */
    public List<ReofferTrans> reoffer(List<OfferedChallenge> chs, Config config){
        if(chs.isEmpty())return List.create();
        return List.create(reoffer(chs.lookup(Util.random(chs.length())), config));
    }
    
    /** Do the actual price lowering */
    public ReofferTrans reoffer(OfferedChallenge ch, Config config){
        log.notify("Reoffer Task : #" + ch.getKey());
        return new ReofferTrans(ch.getKey(),
                Math.max(ch.getPrice() - config.getMindecr() - 0.0001, 0));
    }
}
