package player.tasks;

import logging.Logger;
import scg.Util;
import scg.gen.*;
import edu.neu.ccs.demeterf.lib.*;
import hidden.Tools;

/** Provide Problem instances for accepted Challenges (offered by you) */
public class ProvideTask {

    /** Number of Vars and Clauses to use... */
    protected static final int NUM_VARS = 22;
    protected static final int NUM_CLAUSES = 10;

    protected final Logger log;

    /** Create a ProvideTask with the given Logger */
    public ProvideTask(Logger l){ log = l; }

    /** Do the actual providing of Problem instances */
    public Solution createSecret(Problem p){
        //return new Solution(ListMap.create(SolveTask.randomAssign(p.getVars(), Util.random())));
        return new Solution(Map.create(SolveTask.randomAssign(p.getVars(), Util.random())));
    }
    
    /** Do the actual providing of Problem instances */
    public ProvideTrans provide(AcceptedChallenge ch){
        log.notify("Providing : #" + ch.getKey());
        // SECRET UPDATE: If we offered a Secret challenge, then we must
        //                  provide a secret solution
        Problem prob = createProb(ch.getPred());
        Option<Solution> secret = !ch.isSecret() ? Option.<Solution>none() : Option.some(createSecret(prob));
        return new ProvideTrans(prob, secret, ch.getKey());
    }

    /** Static list of variables to draw from... */
    static List<Var> vars = List.buildlist(new List.Build<Var>() {
        public Var build(int i){ return new Var(new ident("v" + i)); }
    }, NUM_VARS);

    /** Create a random problem instance of the given ProblemType */
    protected Problem createProb(ProblemType t){
        final List<Integer> type = List.create(Tools.importantRelation(t));
        return new Problem(vars, List.buildlist(new List.Build<Clause>() {
            public Clause build(int i){
                int v = Util.random(vars.length());
                return new Clause(type.lookup(Util.random(type.length())),
                        List.create(vars.lookup(v), vars
                                .lookup((v + 1) % vars.length()), vars.lookup((v + 2) % vars.length())));
            }
        }, NUM_CLAUSES));
    }
    
    public static void main(String[] args){
        Tools.updatePreferences(new ProblemType(ListSet.create(127,14)), 0.2);
        Tools.printPrefs();
    }
};
