package player.smarttasks;

import logging.Logger;
import scg.gen.*;
import scg.Util;
import edu.neu.ccs.demeterf.lib.*;
import hidden.Tools;

/** Solve the provided Problem instances ASAP */
public class SolveTask extends player.tasks.SolveTask{
    /** The Number of random assignments to try */
    static final int NUM_ASSIGNS = 20;
    /** The number of "zones" for our random bias */
    static final int PARTITIONS = 50;

    /** Create a SolveTask with the given Logger */
    public SolveTask(Logger l) { super(l); }

    /** Do the actual solving of Problem instances */
    protected Solution solve(ProvidedChallenge ch, double price, double factor){
        Problem p = ch.getInstance();
        Best best = findBest(p);
        double prof = Tools.payback(price, best.quality, factor)-price;
        log.notify("Solving for a "+((prof>0)?"PROFIT":"LOSS") + " of "+prof);
        if(prof<0){
            Tools.updatePreferences(ch.getPred(), best.quality);
        }
        Solution ret = new Solution(Map.create(best.assign));
        return ret;
    }
    
    /** Helps to collect the Best assignment */
    public static class Best{
        public double quality;
        public List<Entry<Var, Boolean>> assign;
        Best(){ this(-1.0, null); }
        Best(double q, List<Entry<Var, Boolean>> a){ quality = q; assign = a; }
    }
    /** Solve the given Problem Instance */
    Best findBest(final Problem p){
        return findBest(p,NUM_ASSIGNS);
    }
    /** Solve the given Problem Instance, using "times" random asssginments */
    public static Best findBest(final Problem p, int times){
        final List<Var> vars = usedVars(p);
        Best best =
            List.buildlist(new List.Build<List<Entry<Var, Boolean>>>(){
                public List<Entry<Var, Boolean>> build(int i){
                    return randomAssign(vars, Util.random());//PARTITIONS)/(double)PARTITIONS);
                }
            }, times).fold(new List.Fold<List<Entry<Var, Boolean>>,Best>(){
                public Best fold(List<Entry<Var, Boolean>> s, Best b){
                    if(b.quality == 1.0)return b;
                    double qual = Tools.quality(p, s);
                    if(qual < b.quality)return b;
                    return new Best(qual,s);
                }
            }, new Best());
        return best;
    }
    
    /** Used Variables from a Problem Instance */
    static List<Var> usedVars(Problem p){
        return p.getVars();
    }
}
