package player.smarttasks;

import edu.neu.ccs.demeterf.lib.Map;
import edu.neu.ccs.demeterf.lib.List;
import player.PlayerFactory;
import player.smarttasks.SolveTask;
import logging.Logger;
import scg.gen.*;
import hidden.Tools;

/** Provide Problem instances for accepted Challenges (offered by you) */
public class ProvideTask extends player.tasks.ProvideTask{
    /** Number of assignments to search for a secret solution */
    static int SECRET_TRIES = 50;
    
    /** Provide good secrets?? */
    protected boolean goodSecrets = PlayerFactory.globalOptionSet(PlayerFactory.GOODSECRETS);
    
    /** Create a ProvideTask with the given Logger */
    public ProvideTask(Logger l) { super(l); }

    /** Create a random problem instance of the given ProblemType */
    protected Problem createProb(ProblemType t){
        List<Integer> sorted = t.getType().toList().sort(new List.Comp<Integer>(){
            public boolean comp(Integer a, Integer b){ return a < b; }
        });
        if(sorted.length() > 1)sorted = sorted.sublist(0,1);
        return new Problem(Tools.symmetric(sorted, NUM_VARS, 3));
    }
    /** Do the actual providing of Problem instances */
    public Solution createSecret(Problem p){
        if(goodSecrets){
            SolveTask.Best best = SolveTask.findBest(p, SECRET_TRIES);
            log.notify("Secret quality: "+best.quality);
            return new Solution(Map.create(best.assign));
        }
        return super.createSecret(p);
    }
}
