package player.smarttasks;

import logging.Logger;
import scg.gen.PlayerContext;
import player.PlayerFactory;

/**
 * Player class, responsible for taking a single turn. We deligate to separate
 * Tasks classes to make things a little easier to understand. See
 * {@link player.tasks Tasks}.
 */
public class Player extends player.Player{

    protected Player(PlayerContext ctxt, Logger l){ super(ctxt,l); }

    /** Construct a new player with the given Context */
    public static Player create(PlayerContext ctxt, Logger l){
        l.notify("This is the *SMART* Player!!");
        return new Player(ctxt, l);
    }
    
    protected OfferTask offerer(Logger log){ return new OfferTask(log,context.getConfig()); }
    protected AcceptTask accepter(Logger log){ return new AcceptTask(log); }
    protected ProvideTask provider(Logger log){ return new ProvideTask(log); }
    protected SolveTask solver(Logger log){
        log.notify(" SMART SOLVE");
        if(PlayerFactory.globalOptionSet(PlayerFactory.PARSOLVE))
            return new ParSolveTask(log, context.getConfig());
        return new SolveTask(log);    
    }
    protected ReofferTask reofferer(Logger log){ return new ReofferTask(log); }
}
