package player.smarttasks;

import logging.Logger;
import scg.gen.*;
import scg.Util;
import edu.neu.ccs.demeterf.lib.*;
import hidden.Tools;

/** Solve the provided Problem instances In Parallel */
public class ParSolveTask extends SolveTask{
    /** How many at a time? */
    final static int HOW_MANY = 5;
    /** Time Padding */
    final static int PADDING = 30000; // Milli-Secconds
    /** The current Config */
    final Config config;
    /** Create a SolveTask with the given Logger */
    public ParSolveTask(Logger l, Config c) { super(l); config = c; }

    /** Do the actual solving of Problem instances */
    public List<Transaction> solve(List<ProvidedChallenge> chs, final double factor, long start){
        if(chs.isEmpty())return List.create();
        log.notify("Parallel Solve");
        final List<SolveThread> solvers = chs.map(new List.Map<ProvidedChallenge,SolveThread>(){
            public SolveThread map(ProvidedChallenge ch){
                return new SolveThread(ch);
            }
        });
        long timeleft = (config.getTurndur()*1000) - (System.currentTimeMillis()-start);
        log.event("Solving for "+((timeleft-PADDING)/1000.0)+" sec.");
        try{ Thread.sleep(timeleft-PADDING); }catch(InterruptedException e){
            log.error("Solver Rest Interrupted");
        }
        for(SolveThread s : solvers){
            s.setDone();
            try{ s.join(); }catch(InterruptedException e){
                log.error("Solver Join Interrupted");
            }
        }
        return solvers.map(new List.Map<SolveThread,Transaction>(){
            public Transaction map(SolveThread s){
                Best b = s.getResult();
                double prof = Tools.payback(s.prov.getPrice(), b.quality, factor)-s.prov.getPrice();
                log.notify("Solving "+s.prov.getPred()+"["+s.prov.getPrice()+" @ "+b.quality+"] for a "+((prof>0)?"PROFIT":"LOSS") + " of "+prof);
                if(prof<0)
                    Tools.updatePreferences(s.prov.getPred(), b.quality);
                return new SolveTrans(new Solution(Map.create(b.assign)), s.prov.getKey());
            }
        });
    }
    
    class SolveThread extends Thread{
        Best best = new Best();
        final ProvidedChallenge prov;
        boolean done = false;
        
        SolveThread(ProvidedChallenge ch){ prov = ch; this.start(); }
        public void run(){
            while(!getDone()){
                setResult(findBest(prov.getInstance(), HOW_MANY));
            }
        } 
        public synchronized void setDone(){ done = true; }
        public synchronized boolean getDone(){ return done; }
        public synchronized void setResult(Best b){
            if(b.quality > best.quality){
                //log.event("Setting Best ["+prov.getKey()+"] quality: "+b.quality);
                best = b;
            }
        }
        public synchronized Best getResult(){ return best; }
    } 
}
