package player.smarttasks;

import player.PlayerFactory;
import hidden.Tools;
import logging.Logger;
import scg.gen.OfferTrans;
import scg.gen.ProblemType;
import scg.gen.ChallengeKind;
import scg.gen.Config;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Entry;

/** Offer new Challenges, at good prices, that are not currently offered. */
public class OfferTask extends player.tasks.OfferTask {
    /** Create a OfferTask with the given Logger */
    public OfferTask(Logger l, Config cfg){ super(l, cfg); }
    /** Provide good secrets?? */
    protected boolean fastPitch = PlayerFactory.globalOptionSet(PlayerFactory.FASTPITCH);
    
    public OfferTrans freshTrans(List<ProblemType> ts){
        ProblemType pt = null;
        ChallengeKind kind = getKind();
        List<Integer> base = List.<Integer>create(127);

        while(base.length() < 2){
            // Try our preferences...
            for (Entry<Integer, Tools.Triple<Integer, Double, Double>> pr : Tools.PREFS_MAP) {
                pt = new ProblemType(base.append(pr.getKey()).removeDuplicates());
                if (!ts.contains(pt)){
                    if(kind.isSecret())return new OfferTrans(kind, pt, 0.999999);
                    return new OfferTrans(kind, pt, pr.getVal().getZ()+0.01);
                }
            }
            if(!fastPitch)break;
            base = base.push(127+2*base.length());
        }
        // Otherwise, settle for a random one
        return super.freshTrans(ts, 1.0);
    }
}
