package player.smarttasks;

import player.PlayerFactory;
import logging.Logger;
import scg.gen.*;
import hidden.Tools;
import edu.neu.ccs.demeterf.lib.*;

/** Accept Challenges we want to solve... choose wisely :) */
public class AcceptTask extends player.tasks.AcceptTask{
    /** Provide good secrets?? */
    protected boolean newAccept = PlayerFactory.globalOptionSet(PlayerFactory.NEWACCEPT);
    /** Threashold for accepting secret challenges */
    static double secretThresh = 0.98;
    
    /** Create a AcceptTask with the given Logger */
    public AcceptTask(Logger l) { super(l); }
    
    /** Buy the good ones */
    protected boolean profitable(final OfferedChallenge off, Config config){
        int rel = Tools.importantRelation(off.getPred());
        if(off.isSecret()){
            return (rel == 0 || off.getPrice() <= secretThresh);
        }
        if(Tools.PREFS_MAP.containsKey(rel)){
            if(newAccept)
                return off.getPrice() < Tools.PREFS_MAP.get(rel).getZ();
            return off.getPrice() < (Tools.PREFS_MAP.get(rel).getY()+0.05);
        }
        return off.getPrice() <= 1.0;
    }
}