import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class Registery {
	List<String> domains = new ArrayList<String>();
	Map<String, String> instanceToDomain = new HashMap<String, String>();
	Map<String, String> instanceSetToDomain = new HashMap<String, String>();
	Map<String, String> solutionToDomain = new HashMap<String, String>();
	
	public void RegisterDomain(String domain){
		domains.add(domain);
	}
	
	public void RegisterInstance(String instance, String domain){
		instanceToDomain.put(instance, domain);
	}
	
	public void RegisterInstanceSet(String instanceSet, String domain){
		instanceToDomain.put(instanceSet, domain);	
	}
	
	public void RegisterSolution(String solution, String domain){
		instanceToDomain.put(solution, domain);
	}
	
	public String domainOfInstance(String instance){
		return instanceToDomain.get(instance);
	}
	public String domainOfInstanceSet(String instance){
		return instanceSetToDomain.get(instance);
	}
	public String domainOfSolution(String instance){
		return solutionToDomain.get(instance);
	}


}
	