/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.util;

import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.dispatch.MethodDB;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.RE;
import edu.neu.ccs.demeterf.lib.ident;
import edu.neu.ccs.demeterf.lib.verbatim;
import edu.neu.ccs.demeterf.util.Option;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static boolean debugOn = false;
    public static boolean warningOn = false;
    public static boolean allowNull = false;
    public static boolean skipPrivate = true;
    public static HashSet<Class<?>> builtIns = new HashSet();
    public static Class<?>[] builtInArray;
    private static HashMap<Class<?>, List<Field>> memo;
    static HashMap<Class<?>, Class<?>> unboxed;
    static HashMap<Class<?>, Class<?>> boxed;

    static {
        Class<?>[] classArray = builtInArray = new Class[]{Short.TYPE, Short.class, Integer.class, Integer.TYPE, Float.class, Float.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, String.class, Boolean.class, Boolean.TYPE, Character.TYPE, Character.class, ident.class, verbatim.class};
        int n2 = builtInArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<?> c2 = classArray[n3];
            builtIns.add(c2);
            ++n3;
        }
        memo = new HashMap();
        unboxed = new HashMap();
        unboxed.put(Short.TYPE, Short.class);
        unboxed.put(Integer.TYPE, Integer.class);
        unboxed.put(Long.TYPE, Long.class);
        unboxed.put(Float.TYPE, Float.class);
        unboxed.put(Double.TYPE, Double.class);
        unboxed.put(Character.TYPE, Character.class);
        unboxed.put(Byte.TYPE, Byte.class);
        unboxed.put(Boolean.TYPE, Boolean.class);
        boxed = new HashMap();
        boxed.put(Short.class, Short.TYPE);
        boxed.put(Integer.class, Integer.TYPE);
        boxed.put(Long.class, Long.TYPE);
        boxed.put(Float.class, Float.TYPE);
        boxed.put(Double.class, Double.TYPE);
        boxed.put(Character.class, Character.TYPE);
        boxed.put(Byte.class, Byte.TYPE);
        boxed.put(Boolean.class, Boolean.TYPE);
    }

    private Util() {
    }

    public static boolean setDebug(boolean b) {
        debugOn = b;
        return debugOn;
    }

    public static boolean setWarning(boolean b) {
        warningOn = b;
        return warningOn;
    }

    public static boolean setAllowNull(boolean b) {
        allowNull = b;
        return allowNull;
    }

    public static boolean setSkipPrivate(boolean b) {
        skipPrivate = b;
        return skipPrivate;
    }

    public static void print(String s2) {
        if (debugOn) {
            System.out.print(s2);
        }
    }

    public static void println(String s2) {
        Util.print(String.valueOf(s2) + "\n");
    }

    public static void addBuiltIn(Class<?> c2) {
        builtIns.add(c2);
    }

    public static void addBuiltIns(Class<?> ... cs) {
        Class<?>[] classArray = cs;
        int n2 = cs.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<?> c2 = classArray[n3];
            builtIns.add(c2);
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getFuncFields(Class<?> c2) {
        HashMap<Class<?>, List<Field>> hashMap = memo;
        synchronized (hashMap) {
            if (memo.containsKey(c2)) {
                return memo.get(c2);
            }
            Class<?> cc = c2;
            List<Field> lst = List.create();
            while (c2 != null && !c2.isPrimitive()) {
                Field[] fieldArray = c2.getDeclaredFields();
                int n2 = fieldArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Field f = fieldArray[n3];
                    int m = f.getModifiers();
                    if (!(Modifier.isStatic(m) || skipPrivate && Modifier.isPrivate(m))) {
                        lst = lst.push(f);
                    }
                    ++n3;
                }
                c2 = c2.getSuperclass();
            }
            lst = lst.reverse();
            memo.put(cc, lst);
            return lst;
        }
    }

    public static Object[] addArg(Object[] o, Option arg) {
        Object[] r2 = o;
        if (arg.some()) {
            r2 = new Object[o.length + 1];
            int i = 0;
            while (i < o.length) {
                r2[i] = o[i];
                ++i;
            }
            r2[i] = arg.get();
        }
        return r2;
    }

    public static Object applyFObj(Object f, Object[] o, MethodDB<Method> db, String meth, int def) {
        Class<?>[] cs = Util.classesFromObjects(o, o.length);
        DBEntry<Method> ml = db.matchEntryFast(cs);
        if (ml == null) {
            if (def < 0) {
                throw new RuntimeException("\n  DemeterF: Did not find a match for: \n      " + Util.signature(f.getClass(), meth, o, o.length) + "\n");
            }
            return o[def];
        }
        return Util.applyMethod(ml.getMethod(), f, o);
    }

    public static <R> R applyMethod(Method m, Object targ2, Object[] args2) {
        try {
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            Object ret2 = m.invoke(targ2, Util.objectSubset(args2, m.getParameterTypes().length));
            return (R)ret2;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            if (ite.getTargetException() instanceof Error) {
                throw (Error)ite.getCause();
            }
            throw new RuntimeException(ite.getCause());
        }
    }

    static void checkWarnMethods(List<DBEntry<Method>> lst, Class<?> c2) {
        if (!warningOn) {
            return;
        }
        DBEntry<Method> theOne = lst.top();
        while (!(lst = lst.pop()).isEmpty()) {
            DBEntry<Method> e2 = lst.top();
            if (e2.numArgs() >= theOne.numArgs() || e2.numArgs() <= 0 || !theOne.arg(0).isAssignableFrom(e2.arg(0)) || theOne.arg(0).equals(e2.arg(0))) continue;
            System.err.println("\n %% DemeterF Warning: A method with more arguments has been\n      chosen instead of one with a more specific first argument\n  function class: " + c2.getSimpleName() + "\n" + "  * Chose : " + Util.dbEntrySig(theOne) + "\n" + "  *   Not : " + Util.dbEntrySig(e2) + "\n");
            return;
        }
    }

    private static String dbEntrySig(DBEntry<?> e2) {
        return e2.toString();
    }

    public static Class<?>[] classesFromObjects(Object[] o, int len) {
        Class[] cs = new Class[len];
        int i = 0;
        while (i < len) {
            if (o[i] == null) {
                if (allowNull) {
                    cs[i] = null;
                } else {
                    Util.nullError();
                }
            } else {
                cs[i] = o[i].getClass();
            }
            ++i;
        }
        return cs;
    }

    public static Object[] objectSubset(Object[] o, int len) {
        if (o.length == len) {
            return o;
        }
        Object[] os = new Object[len];
        int i = 0;
        while (i < len) {
            os[i] = o[i];
            ++i;
        }
        return os;
    }

    public static String signature(Method m) {
        return Util.signature(m.getDeclaringClass(), m.getName(), m.getParameterTypes(), m.getParameterTypes().length);
    }

    public static String signature(Constructor<?> c2) {
        return Util.signature(c2.getDeclaringClass(), c2.getDeclaringClass().getSimpleName(), c2.getParameterTypes(), c2.getParameterTypes().length);
    }

    public static String signature(Class<?> c2, String name2, Object[] o, int max) {
        return Util.signature(c2, name2, Util.classesFromObjects(o, max), max);
    }

    public static String signature(Class<?> c2, String name2, Class<?>[] cs, int max) {
        String[] ss = new String[cs.length];
        int i = 0;
        while (i < max) {
            ss[i] = cs[i].getSimpleName();
            ++i;
        }
        return Util.signature(c2, name2, ss, max);
    }

    public static String signature(Class<?> c2, String name2, String[] cs, int max) {
        String s2 = String.valueOf(c2.getSimpleName()) + "." + name2 + "(";
        int i = 0;
        while (i < max) {
            s2 = String.valueOf(s2) + (cs == null ? "null" : cs[i]);
            if (i < max - 1) {
                s2 = String.valueOf(s2) + ", ";
            }
            ++i;
        }
        return String.valueOf(s2) + ")";
    }

    public static void nullError() {
        throw new RuntimeException("\n  DemeterF: Null Object Found\n");
    }

    public static void nullFieldError(Field f) {
        throw new RuntimeException("\n  DemeterF: Null Field Found:  " + f.getDeclaringClass().getSimpleName() + "." + f.getName() + "\n");
    }

    public static Class<?> box(Class<?> c2) {
        if (c2.isPrimitive()) {
            return unboxed.get(c2);
        }
        return c2;
    }

    public static Class<?> unbox(Class<?> c2) {
        if (boxed.containsKey(c2)) {
            return boxed.get(c2);
        }
        return c2;
    }

    public static String capCase(String s2) {
        if (s2.length() == 0) {
            return s2;
        }
        return String.valueOf(Character.toUpperCase(s2.charAt(0))) + s2.substring(1);
    }

    public static String writeFile(String name2, String suf, String cls, String dir, String h) {
        String file2 = String.valueOf(dir) + File.separatorChar + name2 + suf;
        try {
            PrintStream out = new PrintStream(new FileOutputStream(file2));
            out.println(h);
            out.println(cls);
            out.close();
        }
        catch (FileNotFoundException fnf) {
            throw new RE("Unable to Write File: " + file2 + "\n" + "   * Please Check that directories exist and\n" + "       permissions are set correctly");
        }
        return cls;
    }

    public static void createWritableDir(String path) {
        File f = new File(path);
        if (!f.exists() || !f.canWrite()) {
            f.setWritable(true);
            if (!f.mkdirs()) {
                throw new RE("Unable to Create Dir: " + path + "\n" + "   * Please Check that permissions are set correctly");
            }
        }
    }
}

