/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.stackless;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.stackless.Continuation;
import edu.neu.ccs.demeterf.util.Option;
import edu.neu.ccs.demeterf.util.Util;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapTrav
extends Traversal {
    static boolean verbose = false;

    public void setVerbose(boolean v2) {
        verbose = v2;
    }

    public HeapTrav(FC f) {
        super(f);
    }

    public HeapTrav(FC f, Control c2) {
        super(f, c2);
    }

    @Override
    protected <Ret> Ret traverse(Object o, Option arg) {
        Continuation base = new Hole(o, arg);
        while (!base.isValue()) {
            base = ((Continuation)base).step();
        }
        return (Ret)((Value)base).val;
    }

    class Hole
    extends Continuation {
        final Object prev;
        final Option targ;

        public Hole(Object p, Option ta) {
            super(null);
            this.prev = p;
            this.targ = ta;
            this.link = this;
        }

        public Hole(Object p, Option ta, Continuation l2) {
            super(l2);
            this.prev = p;
            this.targ = ta;
        }

        public Continuation apply(Object v2) {
            return new Value(v2);
        }

        public Continuation step() {
            if (HeapTrav.this.control.isBuiltIn(this.prev.getClass())) {
                return this.apply(this.dispatch(new Object[]{this.prev}, this.targ, true));
            }
            return new ObjCont(this.prev, this.targ, List.<Object>create(), Util.getFuncFields(this.prev.getClass()), this);
        }

        public Object dispatch(Object[] os, Option ta, boolean prim) {
            try {
                return HeapTrav.this.applyBuilder(Util.addArg(os, ta), prim);
            }
            catch (RuntimeException e2) {
                if (!verbose) {
                    throw e2;
                }
                throw new RuntimeException("In HeapTrav: " + e2.toString() + "\n StackTrace:\n" + this.stackTrace());
            }
        }

        public boolean isHole() {
            return true;
        }

        public String stackTrace() {
            String ret2 = "    " + this.prev.getClass().getSimpleName();
            return String.valueOf(ret2) + "\n" + (this.link.isHole() && this.link != this ? ((Hole)this.link).stackTrace() : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ObjCont
    extends Hole {
        final List<Object> results;
        final List<Field> left;

        public ObjCont(Object p, Option ta, List<Object> rs, List<Field> lft, Continuation l2) {
            super(p, ta, l2);
            this.results = rs;
            this.left = lft;
        }

        @Override
        public Continuation apply(Object v2) {
            return new ObjCont(this.prev, this.targ, this.results.push(v2), this.left.pop(), this.link);
        }

        @Override
        public Continuation step() {
            if (this.left.isEmpty()) {
                List<Object> args2 = this.results.reverse().push(this.prev);
                return this.link.apply(this.dispatch(args2.toArray((Object[])new Object[args2.length()]), this.targ, false));
            }
            Field f = this.left.top();
            try {
                Option farg;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                Object o = f.get(this.prev);
                if (HeapTrav.this.control.skip(this.prev.getClass(), f.getName())) {
                    return this.apply(o);
                }
                if (o == null) {
                    System.err.println("NULL FIELD: " + f.getDeclaringClass().getName() + "." + f.getName());
                }
                Class<?> fc = o.getClass();
                Option option = farg = this.targ.some() ? HeapTrav.this.applyAugment(new Object[]{this.prev, this.targ.get()}, f) : this.targ;
                if (HeapTrav.this.control.isBuiltIn(fc)) {
                    return this.apply(this.dispatch(new Object[]{o}, farg, true));
                }
                return new ObjCont(o, farg, List.<Object>create(), Util.getFuncFields(fc), this);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        }
    }

    public class Value
    extends Continuation {
        final Object val;

        public Value(Object what) {
            super(null);
            this.val = what;
        }

        public boolean isValue() {
            return true;
        }

        public Continuation apply(Object v2) {
            throw new RuntimeException("Cannot Apply a Value to a Value");
        }

        public Continuation step() {
            return this;
        }
    }
}

