/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.perform;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.perform.AbstTraversal;
import edu.neu.ccs.demeterf.perform.MethodDB;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Traversal
extends AbstTraversal {
    protected FC func;
    protected MethodDB<Method> buildDB;
    protected MethodDB<Method> augDB;
    static Class[] emptyClass = new Class[0];

    public static Traversal onestep(FC f) {
        return new Traversal(f, Control.nowhere());
    }

    public Traversal(FC f) {
        this(f, Control.everywhere());
    }

    public Traversal(FC f, Control c2) {
        super(c2);
        this.func = f;
        this.buildDB = MethodDB.createMethodDB(f.getClass(), FC.buildMethodName);
        this.augDB = MethodDB.createMethodDB(f.getClass(), FC.augMethodName);
    }

    @Override
    protected Object applyBuilder(Object[] o, boolean prim) {
        return Traversal.applyFObj(this.func, o, this.buildDB, FC.buildMethodName, prim ? 0 : -1);
    }

    @Override
    protected Object applyAugment(Object[] o, Class<?> pc, String fn) {
        Fields.any field2 = Fields.any;
        if (pc != null) {
            String fName = String.valueOf(pc.getName()) + "$" + fn;
            try {
                Class<?> fc = Class.forName(fName);
                fc.getConstructor(emptyClass).setAccessible(true);
                field2 = fc.newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return Traversal.applyFObj(this.func, new Object[]{o[0], field2, o[1]}, this.augDB, FC.augMethodName, 2);
    }

    public static Object applyFObj(Object f, Object[] o, MethodDB<Method> db, String meth, int def) {
        int len = o.length;
        Class[] cs = new Class[len];
        int i = 0;
        while (i < len) {
            if (o[i] == null) {
                throw new RuntimeException(" NULL REF: " + o[0].getClass() + " field # " + i);
            }
            cs[i] = o[i].getClass();
            ++i;
        }
        DBEntry<Method> ml = db.matchEntryFast(cs, len);
        if (ml == null) {
            if (def < 0) {
                throw new RuntimeException("\n  DemeterF: Did Not Find a Match for: \n      " + Help.signature(f.getClass(), meth, cs, o.length) + "\n");
            }
            return o[def];
        }
        Method m = ml.getMethod();
        Object ret2 = def >= 0 ? o[def] : null;
        try {
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            ret2 = m.invoke(f, Traversal.objectSubset(o, ml.numArgs()));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return ret2;
    }

    public static Object[] objectSubset(Object[] o, int len) {
        if (o.length == len) {
            return o;
        }
        Object[] os = new Object[len];
        int i = 0;
        while (i < len) {
            os[i] = o[i];
            ++i;
        }
        return os;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Help {
        Help() {
        }

        public static String signature(Class<?> c2, String name2, Class<?>[] cs, int max) {
            String[] ss = new String[cs.length];
            int i = 0;
            while (i < max) {
                ss[i] = cs[i].getSimpleName();
                ++i;
            }
            return Help.signature(c2, name2, ss, max);
        }

        public static String signature(Class<?> c2, String name2, String[] cs, int max) {
            String s2 = String.valueOf(c2.getSimpleName()) + "." + name2 + "(";
            int i = 0;
            while (i < max) {
                s2 = String.valueOf(s2) + (cs == null ? "null" : cs[i]);
                if (i < max - 1) {
                    s2 = String.valueOf(s2) + ", ";
                }
                ++i;
            }
            return String.valueOf(s2) + ")";
        }
    }
}

