/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.perform;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.perform.Traversal;
import edu.neu.ccs.demeterf.util.Option;
import edu.neu.ccs.demeterf.util.Util;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapTrav
extends Traversal {
    public HeapTrav(FC f) {
        super(f);
    }

    public HeapTrav(FC f, Control c2) {
        super(f, c2);
    }

    @Override
    protected <Ret> Ret traverse(Object o, Option arg) {
        Cont base = new Hole(o, arg);
        while (!((Cont)base).isValue()) {
            base = ((Cont)base).step();
        }
        return (Ret)((Value)base).val;
    }

    static abstract class Cont {
        Cont() {
        }

        public abstract boolean isValue();

        public abstract Cont apply(Value var1);

        public abstract Cont step();
    }

    class Hole
    extends Cont {
        final Object prev;
        final Option targ;
        final Cont link;

        public Hole(Object p, Option ta) {
            this.prev = p;
            this.targ = ta;
            this.link = this;
        }

        public Hole(Object p, Option ta, Cont l2) {
            this.prev = p;
            this.targ = ta;
            this.link = l2;
        }

        public boolean isValue() {
            return false;
        }

        public Cont apply(Value v2) {
            return this == this.link ? v2 : this.link.apply(v2);
        }

        public Cont step() {
            if (HeapTrav.this.control.isBuiltIn(this.prev.getClass())) {
                return this.apply(this.dispatch(new Object[]{this.prev}, this.targ, true));
            }
            return new ObjCont(this.prev, this.targ, List.<Object>create(), Util.getFuncFields(this.prev.getClass()), this);
        }

        public Value dispatch(Object[] os, Option ta, boolean prim) {
            return new Value(HeapTrav.this.applyBuilder(Util.addArg(os, ta), prim));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ObjCont
    extends Hole {
        final List<Object> results;
        final List<Field> left;

        public ObjCont(Object p, Option ta, List<Object> rs, List<Field> lft, Cont l2) {
            super(p, ta, l2);
            this.results = rs;
            this.left = lft;
        }

        @Override
        public Cont apply(Value v2) {
            return new ObjCont(this.prev, this.targ, this.results.push(v2.val), this.left.pop(), this.link);
        }

        @Override
        public Cont step() {
            if (this.left.isEmpty()) {
                List<Object> args2 = this.results.reverse().push(this.prev);
                return this.link.apply(this.dispatch(args2.toArray((Object[])new Object[args2.length()]), this.targ, false));
            }
            Field f = this.left.top();
            try {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                Object o = f.get(this.prev);
                if (HeapTrav.this.control.skip(this.prev.getClass(), f.getName())) {
                    return this.apply(new Value(o));
                }
                Option farg = this.targ.some() ? HeapTrav.this.applyAugment(new Object[]{this.prev, this.targ.get()}, f) : this.targ;
                return new Hole(o, farg, this);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        }
    }

    public class Value
    extends Cont {
        final Object val;

        public Value(Object what) {
            this.val = what;
        }

        public boolean isValue() {
            return true;
        }

        public Cont apply(Value v2) {
            throw new RuntimeException("Cannot Apply a Value to a Value");
        }

        public Cont step() {
            return this;
        }
    }
}

