/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.lib.EmptyS;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.PESepList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SepList<Syn, X> {
    protected SepList() {
    }

    public abstract boolean isEmpty();

    public abstract X top();

    public abstract PESepList<Syn, X> pop();

    public abstract boolean hasSyntax();

    public abstract Syn topSyntax();

    public abstract List<X> toList();

    public abstract SepList<Syn, X> push(X var1, Syn var2);

    public abstract SepList<Syn, X> reverse();

    protected abstract SepList<Syn, X> reverse(SepList<Syn, X> var1, Syn var2);

    public abstract int length();

    public abstract X lookup(int var1);

    public abstract String toString();

    public static <Syn, X> SepList<Syn, X> create() {
        return new EmptyS();
    }

    public static <Syn, X> SepList<Syn, X> create(Syn s2, X ... xa) {
        return SepList.create(s2, xa, 0);
    }

    public static <Syn, X> SepList<Syn, X> create(Syn s2, X[] xa, int i) {
        SepList<Syn, X> res2 = SepList.create();
        while (i < xa.length) {
            res2 = res2.push(xa[i], s2);
            ++i;
        }
        return res2.reverse();
    }

    public static <Syn, X> SepList<Syn, X> create(Syn s2, Iterable<X> xs) {
        SepList<Syn, X> res2 = SepList.create();
        for (X x2 : xs) {
            res2 = res2.push(x2, s2);
        }
        return res2.reverse();
    }

    public static <Syn, X> SepList<Syn, X> buildlist(Syn s2, List.Build<X> b, int len) {
        SepList<Syn, X> lst = SepList.create();
        while (len-- > 0) {
            lst = lst.push(b.build(len), s2);
        }
        return lst;
    }

    public <Y> Y fold(Fold<Syn, X, Y> f, Y b) {
        return this.foldl(f, b);
    }

    public abstract <Y> Y foldl(Fold<Syn, X, Y> var1, Y var2);

    public <Y> Y foldr(Fold<Syn, X, Y> f, Y b) {
        return this.reverse().foldl(f, b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Fold<Syn, X, Y> {
        public abstract Y fold(X var1);

        public abstract Y fold(X var1, Y var2);

        public abstract Y fold(Syn var1, X var2, Y var3);
    }
}

